function disable_extra_areas()
    -- Disable extra areas
    local e1=Effect.GlobalEffect()
	e1:SetType(EFFECT_TYPE_FIELD)
	e1:SetRange(LOCATION_MZONE)
	e1:SetCode(EFFECT_DISABLE_FIELD)
	e1:SetCondition(aux.TRUE)
	e1:SetValue(0x200020)
    Duel.RegisterEffect(e1,0)
end

function delay_first_turn()
    -- No draw card in Turn 2
    local e1=Effect.GlobalEffect()
    e1:SetType(EFFECT_TYPE_FIELD)
    e1:SetCode(EFFECT_DRAW_COUNT)
    e1:SetCondition(aux.TRUE)
	e1:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
    e1:SetTargetRange(1,1)
    e1:SetValue(0)
    e1:SetReset(RESET_PHASE+PHASE_END,2)
    Duel.RegisterEffect(e1,0)
    -- No Battle Phase in Turn 2
    local e2=e1:Clone()
    e2:SetCode(EFFECT_CANNOT_BP)
    Duel.RegisterEffect(e2,0)
    -- Disable any effect
    local e3= Effect.GlobalEffect()
    e3:SetType(EFFECT_TYPE_FIELD)
    e3:SetTargetRange(LOCATION_ONFIELD+LOCATION_GRAVE+LOCATION_REMOVED, LOCATION_ONFIELD+LOCATION_GRAVE+LOCATION_REMOVED)
    e3:SetTarget(aux.TRUE)
    e3:SetCode(EFFECT_DISABLE)
    e3:SetReset(RESET_PHASE+PHASE_END,1)
    Duel.RegisterEffect(e3,0)
end

function calculate_extra_fields()
    local lp=Duel.GetLP(0)
    if lp<8000-16 and lp>=8000-16-64 then
        local d=8000-16-lp
        Duel.SetLP(0,8000)
        Duel.SetLP(1,8000)
        return 8000-16-lp
    end
    return 0
end

local extra_fields=calculate_extra_fields()
if extra_fields>0 then
    if extra_fields&1==1 then
        delay_first_turn()
    end
    if extra_fields&16==16 then
        disable_extra_areas()
    end
end
