--诱饵人形
local s,id=GetID()
function s.initial_effect(c)
	--Activate
	local e1=Effect.CreateEffect(c)
	e1:SetCategory(CATEGORY_DESTROY)
	e1:SetType(EFFECT_TYPE_ACTIVATE)
	e1:SetCode(EVENT_FREE_CHAIN)
	e1:SetTarget(s.target)
	e1:SetOperation(s.activate)
	c:RegisterEffect(e1)
	--negated
	local e2=Effect.CreateEffect(c)
	e2:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_CONTINUOUS)
	e2:SetProperty(EFFECT_FLAG_CANNOT_DISABLE)
	e2:SetCode(EVENT_CHAIN_NEGATED)
	e2:SetOperation(s.flagop)
	c:RegisterEffect(e2)
	--disabled
	local e3=e2:Clone()
	e3:SetCode(EVENT_CHAIN_DISABLED)
	c:RegisterEffect(e3)
	--destroyed
	local e4=e2:Clone()
	e4:SetCode(EVENT_DESTROYED)
	c:RegisterEffect(e4)
	--redirect
	local e5=Effect.CreateEffect(c)
	e5:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
	e5:SetCode(EVENT_CHAIN_SOLVED)
	e5:SetRange(LOCATION_SZONE+LOCATION_GRAVE+LOCATION_REMOVED)
	e5:SetOperation(s.retop)
	c:RegisterEffect(e5)
end
function s.filter(c)
	return c:IsFaceup()
end
function s.target(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
	if chkc then return chkc:IsLocation(LOCATION_ONFIELD) and s.filter(chkc) end
	if chk==0 then return Duel.IsExistingTarget(Card.IsFaceup,tp,0,LOCATION_ONFIELD,1,e:GetHandler()) end
	e:SetProperty(EFFECT_FLAG_CARD_TARGET)
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_OPERATECARD)
	Duel.SelectTarget(tp,Card.IsFaceup,tp,0,LOCATION_ONFIELD,1,1,e:GetHandler())

	local tc=Duel.GetFirstTarget()
	local label=tc:GetFlagEffectLabel(id)
	if label==nil then
		--print("No quick effects registered for this card.")
		return 
	end
	local tep=tc:GetControler()
	local options={}
    local tes=s.register[label]
	if #tes==0 then return end
	for _,te in ipairs(tes) do
		table.insert(options,{s.can_trigger(te,tep,eg,ep,ev,e,r,rp),te:GetDescription(),te})
	end
	local te=aux.SelectFromOptions(1-tp,table.unpack(options))
	if te~=nil then
		s.force_effect(te,tep)
		Duel.Readjust()
	end
end
function s.can_trigger(te,tep,eg,ep,ev,re,r,rp)
	local condition=te:GetCondition()
	local cost=te:GetCost()
	local target=te:GetTarget()
	return (condition==nil or condition(te,tep,eg,ep,ev,re,r,rp))
		and (cost==nil or cost(te,tep,eg,ep,ev,re,r,rp,0))
		and (target==nil or target(te,tep,eg,ep,ev,re,r,rp,0))
end
function s.force_effect(e,tp)
	local te=e:Clone()
	local tet=e:GetType()
	if tet&EFFECT_TYPE_QUICK_O>0 then
		tet=tet&~EFFECT_TYPE_QUICK_O|EFFECT_TYPE_QUICK_F
	end
	if tet&EFFECT_TYPE_TRIGGER_O>0 then
		tet=tet&~EFFECT_TYPE_TRIGGER_O|EFFECT_TYPE_TRIGGER_F
	end
	te:SetType(tet)
	local target=te:GetTarget()
	te:SetTarget(function(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
		if chk==0 or chkc then
			if target==nil then return true else return target(e,tp,eg,ep,ev,re,r,rp,chk,chkc) end
		end
		if target~=nil then
			target(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
		end
		e:UseCountLimit(tp,1)
		te:Reset()
	end)
	s.originRegisterEffect(e:GetHandler(),te,true)
	Duel.SetChainLimit(function(e,ep,tp) return e==te end)
end
function s.activate(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	if c:IsRelateToEffect(e) then
		Duel.SendtoDeck(c,nil,SEQ_DECKSHUFFLE,REASON_EFFECT,tp,true)
		Duel.Draw(tp,1,REASON_EFFECT)
	end	
end

function s.flagop(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	c:RegisterFlagEffect(id,RESET_EVENT+RESET_CHAIN,0,1)
end
function s.retop(e,tp,eg,ep,ev,re,r,rp)
	local c=e:GetHandler()
	if c:GetFlagEffect(id)==0 then return end
	Duel.SendtoHand(e:GetHandler(),tp,REASON_REDIRECT)
end

s.originRegisterEffect = Card.RegisterEffect
s.register={}
s.register_counter=0
function Card.RegisterEffect(c,e)
	if e:GetType()&EFFECT_TYPE_QUICK_O>0 or e:GetType()&EFFECT_TYPE_TRIGGER_O>0 then
		local label=c:GetFlagEffectLabel(id)
		if label==nil then
			s.register_counter=s.register_counter+1
			label=s.register_counter
			c:RegisterFlagEffect(id,0,0,0,label)
			s.register[label]={}
		end
		table.insert(s.register[label],e)
		--print("Effect registered for card " .. c:GetCode() .. " with label: " .. label)
	end
	return s.originRegisterEffect(c,e)
end

s.originIsActiveType = Effect.IsActiveType
function Effect.IsActiveType(e,typ)
	if e:GetTarget()==s.target and typ&(TYPE_TRAP+TYPE_SPELL+TYPE_MONSTER)>0 then
		return true
	end
	return s.originIsActiveType(e,typ)
end
