-- 血肉零件
function c1994431.initial_effect(c)
    -- ①: Additional normal summon + restriction
    local e1=Effect.CreateEffect(c)
    e1:SetDescription(aux.Stringid(1994431,0))
    e1:SetCategory(CATEGORY_SUMMON_COUNT_LIMIT)
    e1:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
    e1:SetCode(EVENT_SUMMON_SUCCESS)
    e1:SetProperty(EFFECT_FLAG_DELAY)
    e1:SetCountLimit(1,1994431)
    e1:SetCost(c1994431.nscost)
    e1:SetOperation(c1994431.nsop)
    c:RegisterEffect(e1)
    local e2=e1:Clone()
    e2:SetCode(EVENT_SPSUMMON_SUCCESS)
    c:RegisterEffect(e2)
    
    -- ②: Special summon when destroyed
    local e3=Effect.CreateEffect(c)
    e3:SetDescription(aux.Stringid(1994431,1))
    e3:SetCategory(CATEGORY_SPECIAL_SUMMON)
    e3:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
    e3:SetCode(EVENT_DESTROYED)
    e3:SetProperty(EFFECT_FLAG_DELAY)
    e3:SetCountLimit(1,1994431+100)
    e3:SetCondition(c1994431.spcon)
    e3:SetTarget(c1994431.sptg)
    e3:SetOperation(c1994431.spop)
    c:RegisterEffect(e3)
end

-- Effect ①: Additional normal summons
function c1994431.nscost(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.CheckLPCost(tp,1000) end
    Duel.PayLPCost(tp,1000)
end

function c1994431.nsop(e,tp,eg,ep,ev,re,r,rp)
    -- Allow 3 normal summons this turn
    local e1=Effect.CreateEffect(e:GetHandler())
    e1:SetType(EFFECT_TYPE_FIELD)
    e1:SetCode(EFFECT_SET_SUMMON_COUNT_LIMIT)
    e1:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
    e1:SetTargetRange(1,0)
    e1:SetValue(3)
    e1:SetReset(RESET_PHASE+PHASE_END)
    Duel.RegisterEffect(e1,tp)
    
    -- Restrict special summons to Machine monsters
    local e2=Effect.CreateEffect(e:GetHandler())
    e2:SetType(EFFECT_TYPE_FIELD)
    e2:SetCode(EFFECT_CANNOT_SPECIAL_SUMMON)
    e2:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
    e2:SetTargetRange(1,0)
    e2:SetTarget(c1994431.splimit)
    e2:SetReset(RESET_PHASE+PHASE_END)
    Duel.RegisterEffect(e2,tp)
end

function c1994431.splimit(e,c)
    return not c:IsRace(RACE_MACHINE)
end

-- Effect ②: Special summon when destroyed
function c1994431.spcon(e,tp,eg,ep,ev,re,r,rp)
    return  e:GetHandler():IsReason(REASON_BATTLE) or (e:GetHandler():IsReason(REASON_EFFECT))
        and e:GetHandler():IsPreviousLocation(LOCATION_ONFIELD)
end

function c1994431.spfilter(c,e,tp)
    return c:IsSetCard(0x51) and c:IsLevel(4) and not c:IsCode(1994431)
        and c:IsCanBeSpecialSummoned(e,0,tp,false,false)
end

function c1994431.sptg(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.GetLocationCount(tp,LOCATION_MZONE)>0
        and Duel.IsExistingMatchingCard(c1994431.spfilter,tp,LOCATION_DECK,0,1,nil,e,tp) end
    Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,nil,1,tp,LOCATION_DECK)
end

function c1994431.spop(e,tp,eg,ep,ev,re,r,rp)
    if Duel.GetLocationCount(tp,LOCATION_MZONE)<=0 then return end
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_SPSUMMON)
    local g=Duel.SelectMatchingCard(tp,c1994431.spfilter,tp,LOCATION_DECK,0,1,1,nil,e,tp)
    if g:GetCount()>0 then
        Duel.SpecialSummon(g,0,tp,tp,false,false,POS_FACEUP)
    end
end