-- 爆破零件
function c1994430.initial_effect(c)
    -- ①: Destroy and damage effect
    local e1=Effect.CreateEffect(c)
    e1:SetDescription(aux.Stringid(1994430,0))
    e1:SetCategory(CATEGORY_DESTROY+CATEGORY_DAMAGE)
    e1:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
    e1:SetCode(EVENT_SUMMON_SUCCESS)
    e1:SetProperty(EFFECT_FLAG_DELAY+EFFECT_FLAG_CARD_TARGET)
    e1:SetTarget(c1994430.destg)
    e1:SetOperation(c1994430.desop)
    c:RegisterEffect(e1)
    local e2=e1:Clone()
    e2:SetCode(EVENT_SPSUMMON_SUCCESS)
    c:RegisterEffect(e2)
    
    -- ②: Special summon when destroyed
    local e3=Effect.CreateEffect(c)
    e3:SetDescription(aux.Stringid(1994430,1))
    e3:SetCategory(CATEGORY_SPECIAL_SUMMON)
    e3:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
    e3:SetCode(EVENT_DESTROYED)
    e3:SetProperty(EFFECT_FLAG_DELAY)
    e3:SetCountLimit(1,1994430)
    e3:SetCondition(c1994430.spcon)
    e3:SetTarget(c1994430.sptg)
    e3:SetOperation(c1994430.spop)
    c:RegisterEffect(e3)
end

-- Effect ①: Destroy and damage
function c1994430.destg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
    if chkc then return chkc:IsLocation(LOCATION_MZONE) and chkc:IsFaceup() end
    if chk==0 then return Duel.IsExistingTarget(Card.IsFaceup,tp,LOCATION_MZONE,LOCATION_MZONE,1,nil) end
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_DESTROY)
    local g=Duel.SelectTarget(tp,Card.IsFaceup,tp,LOCATION_MZONE,LOCATION_MZONE,1,1,nil)
    local tc=g:GetFirst()
    Duel.SetOperationInfo(0,CATEGORY_DESTROY,g,1,0,0)
    Duel.SetOperationInfo(0,CATEGORY_DAMAGE,nil,0,PLAYER_ALL,tc:GetBaseAttack())
end

function c1994430.desop(e,tp,eg,ep,ev,re,r,rp)
    local tc=Duel.GetFirstTarget()
    if tc and tc:IsRelateToEffect(e) and tc:IsFaceup() then
        local atk=tc:GetBaseAttack()
        if Duel.Destroy(tc,REASON_EFFECT)~=0 then
            Duel.Damage(tp,atk,REASON_EFFECT,true)
            Duel.Damage(1-tp,atk,REASON_EFFECT,true)
            Duel.RDComplete()
        end
    end
end

-- Effect ②: Special summon when destroyed
function c1994430.spcon(e,tp,eg,ep,ev,re,r,rp)
    return (e:GetHandler():IsReason(REASON_BATTLE) or e:GetHandler():IsReason(REASON_EFFECT))
        and e:GetHandler():IsPreviousLocation(LOCATION_ONFIELD)
end

function c1994430.spfilter(c,e,tp)
    return c:IsSetCard(0x51) and c:IsLevel(4) and not c:IsCode(1994430)
        and c:IsCanBeSpecialSummoned(e,0,tp,false,false)
end

function c1994430.sptg(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.GetLocationCount(tp,LOCATION_MZONE)>0
        and Duel.IsExistingMatchingCard(c1994430.spfilter,tp,LOCATION_DECK,0,1,nil,e,tp) end
    Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,nil,1,tp,LOCATION_DECK)
end

function c1994430.spop(e,tp,eg,ep,ev,re,r,rp)
    if Duel.GetLocationCount(tp,LOCATION_MZONE)<=0 then return end
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_SPSUMMON)
    local g=Duel.SelectMatchingCard(tp,c1994430.spfilter,tp,LOCATION_DECK,0,1,1,nil,e,tp)
    if g:GetCount()>0 then
        Duel.SpecialSummon(g,0,tp,tp,false,false,POS_FACEUP)
    end
end