-- 机痕之圣像骑士
function c199442.initial_effect(c)
	-- 连接召唤条件
    aux.AddLinkProcedure(c,aux.FilterBoolFunction(Card.IsLinkType,TYPE_EFFECT),2,3,c199442.lcheck)
    c:EnableReviveLimit()

	-- 效果①：攻击力上升
	local e1=Effect.CreateEffect(c)
	e1:SetType(EFFECT_TYPE_SINGLE)
	e1:SetProperty(EFFECT_FLAG_SINGLE_RANGE)
	e1:SetCode(EFFECT_UPDATE_ATTACK)
	e1:SetRange(LOCATION_MZONE)
	e1:SetValue(c199442.atkval)
	c:RegisterEffect(e1)

	-- 效果②：连接区怪兽不能攻击
	local e2=Effect.CreateEffect(c)
	e2:SetType(EFFECT_TYPE_FIELD)
	e2:SetCode(EFFECT_CANNOT_ATTACK)
	e2:SetRange(LOCATION_MZONE)
	e2:SetTargetRange(LOCATION_MZONE,LOCATION_MZONE)
	e2:SetTarget(c199442.antg)
	c:RegisterEffect(e2)

	-- 效果③：连接区有效果怪兽特殊召唤时触发
	local e3=Effect.CreateEffect(c)
	e3:SetDescription(aux.Stringid(199442,0)) -- 效果描述
	e3:SetCategory(CATEGORY_SPECIAL_SUMMON) -- 效果分类
	e3:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_TRIGGER_O) -- 效果类型
	e3:SetCode(EVENT_SPSUMMON_SUCCESS) -- 触发条件：特殊召唤成功时
	e3:SetRange(LOCATION_MZONE) -- 效果范围：场上
	e3:SetCountLimit(1,199442) -- 1回合1次限制
	e3:SetCondition(c199442.spcon) -- 发动条件
	e3:SetTarget(c199442.sptg) -- 效果目标
	e3:SetOperation(c199442.spop) -- 效果处理
	c:RegisterEffect(e3)
end
function c199442.lcheck(g,lc)
	return g:IsExists(Card.IsLinkSetCard,1,nil,0x116)
end
-- 效果①：攻击力上升
function c199442.atkval(e,c)
	local g=e:GetHandler():GetLinkedGroup():Filter(Card.IsFaceup,nil)
	return g:GetSum(Card.GetBaseAttack)
end

-- 效果②：连接区怪兽不能攻击
function c199442.antg(e,c)
	return e:GetHandler():GetLinkedGroup():IsContains(c)
end

-- 效果③的发动条件
function c199442.spcon(e,tp,eg,ep,ev,re,r,rp)
	-- 检查是否有怪兽在连接区特殊召唤
	local c=e:GetHandler()
	local lg=c:GetLinkedGroup()
	return eg:IsExists(c199442.cfilter,1,nil,lg)
end

-- 效果③的过滤器
function c199442.cfilter(c,lg)
	return c:IsType(TYPE_EFFECT) and lg:IsContains(c)
end

-- 效果③的目标设置
function c199442.sptg(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return Duel.GetLocationCount(tp,LOCATION_MZONE)>0
		and Duel.IsExistingMatchingCard(c199442.spfilter,tp,LOCATION_DECK,0,1,nil,e,tp) end
	Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,nil,1,tp,LOCATION_DECK)
end

-- 效果③的处理
function c199442.spop(e,tp,eg,ep,ev,re,r,rp)
	-- 从卡组特殊召唤1只「星遗物」怪兽
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_SPSUMMON)
	local g=Duel.SelectMatchingCard(tp,c199442.spfilter,tp,LOCATION_DECK,0,1,1,nil,e,tp)
	if #g>0 then
		Duel.SpecialSummon(g,0,tp,tp,false,false,POS_FACEUP)
	end

	-- 让玩家选择是否将这张卡移动到主要怪兽区域
	local c=e:GetHandler()
	if c:IsRelateToEffect(e) and c:IsLocation(LOCATION_MZONE) then
		local opt=Duel.SelectOption(tp,aux.Stringid(199442,1),aux.Stringid(199442,2)) -- 选择是否移动
		if opt==0 then
			Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TOZONE)
			local s=Duel.SelectDisableField(tp,1,LOCATION_MZONE,0,0) -- 选择移动位置
			local nseq=math.log(s,2) -- 将位掩码转换为序列号
			Duel.MoveSequence(c,nseq) -- 移动卡片
		end
	end
end

-- 效果③的特殊召唤过滤器
function c199442.spfilter(c,e,tp)
	return c:IsSetCard(0xfe) and c:IsType(TYPE_MONSTER) and c:IsCanBeSpecialSummoned(e,0,tp,false,false)
end