function c199441.initial_effect(c)
	--Activate
    local e1=Effect.CreateEffect(c)
    e1:SetCategory(CATEGORY_SPECIAL_SUMMON+CATEGORY_GRAVE_SPSUMMON)
    e1:SetType(EFFECT_TYPE_ACTIVATE)
    e1:SetCode(EVENT_FREE_CHAIN)
    e1:SetCountLimit(1,199441,EFFECT_COUNT_CODE_OATH)
    e1:SetOperation(c199441.activate)
    c:RegisterEffect(e1)

    -- ② 额外区怪兽移动 + 检索「圣像骑士」卡
    local e2=Effect.CreateEffect(c)
    e2:SetCategory(CATEGORY_TOHAND+CATEGORY_GRAVE_ACTION)
    e2:SetType(EFFECT_TYPE_IGNITION)
    e2:SetRange(LOCATION_SZONE)
    e2:SetCountLimit(1,{199441,1})
    e2:SetTarget(c199441.mvtg)
    e2:SetOperation(c199441.mvop)
    c:RegisterEffect(e2)

    -- ③ 连接端特殊召唤 → 破坏1张卡
    local e3=Effect.CreateEffect(c)
    e3:SetCategory(CATEGORY_DESTROY)
    e3:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_TRIGGER_O)
    e3:SetCode(EVENT_SPSUMMON_SUCCESS)
    e3:SetRange(LOCATION_SZONE)
    e3:SetCountLimit(1,{199441,2})
    e3:SetCondition(c199441.descon)
    e3:SetTarget(c199441.destg)
    e3:SetOperation(c199441.desop)
    c:RegisterEffect(e3)
end

function c199441.spfilter(c,e,tp)
    return c:IsSetCard(0x116) and c:IsCanBeSpecialSummoned(e,0,tp,false,false)
end
function c199441.activate(e,tp,eg,ep,ev,re,r,rp)
	local cg=Duel.GetMatchingGroup(aux.NecroValleyFilter(c199441.spfilter),tp,LOCATION_GRAVE,0,nil,e,tp)
	if #cg>0 and Duel.GetLocationCount(tp,LOCATION_MZONE)>0
		and Duel.SelectYesNo(tp,aux.Stringid(10125011,0)) then
		Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_SPSUMMON)
		local sg=cg:Select(tp,1,1,nil)
		Duel.SpecialSummon(sg,0,tp,tp,false,false,POS_FACEUP)
	end
end



function c199441.mvfilter(c)
    return c:IsSetCard(0x116) and c:IsType(TYPE_MONSTER) and c:IsLocation(LOCATION_MZONE) and c:IsControler(tp)  and c:IsType(TYPE_LINK)
end
function c199441.searchfilter(c)
    return c:IsSetCard(0x116) and c:IsAbleToHand()
end
function c199441.mvtg(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.IsExistingMatchingCard(c199441.mvfilter,tp,LOCATION_MZONE,0,1,nil)
        and Duel.IsExistingMatchingCard(c199441.searchfilter,tp,LOCATION_GRAVE,0,1,nil) end
end
function c199441.mvop(e,tp,eg,ep,ev,re,r,rp)
    -- 选择目标怪兽
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TARGET)
    local g=Duel.SelectMatchingCard(tp,c199441.mvfilter,tp,LOCATION_MZONE,0,1,1,nil)
    local tc=g:GetFirst()
    if not tc then return end -- 如果没有选择怪兽，则直接返回

    -- 选择移动位置
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_TOZONE)
    local s=Duel.SelectDisableField(tp,1,LOCATION_MZONE,0,0) -- 选择移动位置
    local nseq=math.log(s,2) -- 将位掩码转换为序列号
    Duel.MoveSequence(tc,nseq)
        Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_ATOHAND)
        local sg=Duel.SelectMatchingCard(tp,c199441.searchfilter,tp,LOCATION_GRAVE,0,1,1,nil)
        if #sg>0 then
            Duel.SendtoHand(sg,nil,REASON_EFFECT)
            Duel.ConfirmCards(1-tp,sg)
        end
end


function c199441.cfilter(c,zone)
	local seq=c:GetSequence()
	if c:IsLocation(LOCATION_MZONE) then
		if c:IsControler(1) then seq=seq+16 end
	else
		seq=c:GetPreviousSequence()
		if c:IsPreviousControler(1) then seq=seq+16 end
	end
	return bit.extract(zone,seq)~=0
end
function c199441.descon(e,tp,eg,ep,ev,re,r,rp)
	local zone=Duel.GetLinkedZone(0)+(Duel.GetLinkedZone(1)<<0x10)
	return not eg:IsContains(e:GetHandler()) and eg:IsExists(c199441.cfilter,1,nil,zone)
end
function c199441.destg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
    if chk==0 then return Duel.IsExistingMatchingCard(aux.TRUE,tp,LOCATION_ONFIELD,LOCATION_ONFIELD,1,nil) end
    Duel.SetOperationInfo(0,CATEGORY_DESTROY,nil,1,0,0)
end
function c199441.desop(e,tp,eg,ep,ev,re,r,rp)
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_DESTROY)
    local g=Duel.SelectMatchingCard(tp,aux.TRUE,tp,LOCATION_ONFIELD,LOCATION_ONFIELD,1,1,nil)
    if #g>0 then
        Duel.HintSelection(g)
        Duel.Destroy(g,REASON_EFFECT)
    end
end