-- 电子鱼人-抓取者
function c1994371.initial_effect(c)
    -- 同调素材限制
    local e0=Effect.CreateEffect(c)
    e0:SetType(EFFECT_TYPE_SINGLE)
    e0:SetProperty(EFFECT_FLAG_CANNOT_DISABLE+EFFECT_FLAG_UNCOPYABLE)
    e0:SetCode(EFFECT_SYNCHRO_MATERIAL_CUSTOM)
    e0:SetOperation(c1994371.syncheck)
    c:RegisterEffect(e0)

    -- ① 效果：从墓地特殊召唤
    local e1=Effect.CreateEffect(c)
    e1:SetCategory(CATEGORY_SPECIAL_SUMMON)
    e1:SetType(EFFECT_TYPE_IGNITION)
    e1:SetRange(LOCATION_GRAVE)
    e1:SetCountLimit(1,1994371)
    e1:SetCost(c1994371.spcost)
    e1:SetTarget(c1994371.sptg)
    e1:SetOperation(c1994371.spop)
    c:RegisterEffect(e1)

    -- ② 效果：被送去墓地时回收鱼族怪兽
    local e2=Effect.CreateEffect(c)
    e2:SetCategory(CATEGORY_TOHAND)
    e2:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_TRIGGER_O)
    e2:SetCode(EVENT_TO_GRAVE)
    e2:SetProperty(EFFECT_FLAG_DELAY)
    e2:SetCountLimit(1,19943711)
    e2:SetTarget(c1994371.thtg)
    e2:SetOperation(c1994371.thop)
    c:RegisterEffect(e2)
end

-- 同调素材限制：其他素材必须是水属性
function c1994371.syncheck(g,lc,tp)
    return g:FilterCount(Card.IsAttribute,nil,ATTRIBUTE_WATER)==g:GetCount()-1
end

-- ① 效果：除外水属性以外的怪兽作为代价
function c1994371.spcost(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.IsExistingMatchingCard(c1994371.costfilter,tp,LOCATION_GRAVE,0,1,nil) end
    local g=Duel.GetMatchingGroup(c1994371.costfilter,tp,LOCATION_GRAVE,0,nil)
    Duel.Remove(g,POS_FACEUP,REASON_COST)
end

-- ① 效果：目标设置
function c1994371.sptg(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.GetLocationCount(tp,LOCATION_MZONE)>0
        and e:GetHandler():IsCanBeSpecialSummoned(e,0,tp,false,false) end
    Duel.SetOperationInfo(0,CATEGORY_SPECIAL_SUMMON,e:GetHandler(),1,0,0)
end

-- ① 效果：执行特殊召唤
function c1994371.spop(e,tp,eg,ep,ev,re,r,rp)
    local c=e:GetHandler()
    if c:IsRelateToEffect(e) then
        Duel.SpecialSummon(c,0,tp,tp,false,false,POS_FACEUP)
    end
end

-- ① 效果：除外过滤函数
function c1994371.costfilter(c)
    return not c:IsAttribute(ATTRIBUTE_WATER) and c:IsAbleToRemoveAsCost() and c:IsType(TYPE_MONSTER)
end

-- ② 效果：目标设置
function c1994371.thtg(e,tp,eg,ep,ev,re,r,rp,chk)
    if chk==0 then return Duel.IsExistingMatchingCard(c1994371.thfilter,tp,LOCATION_GRAVE,0,1,nil) end
    Duel.SetOperationInfo(0,CATEGORY_TOHAND,nil,1,tp,LOCATION_GRAVE)
end

-- ② 效果：执行回收
function c1994371.thop(e,tp,eg,ep,ev,re,r,rp)
    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_ATOHAND)
    local g=Duel.SelectMatchingCard(tp,c1994371.thfilter,tp,LOCATION_GRAVE,0,1,1,nil)
    if #g>0 then
        Duel.SendtoHand(g,nil,REASON_EFFECT)
        Duel.ConfirmCards(1-tp,g)
    end
end

-- ② 效果：回收过滤函数
function c1994371.thfilter(c)
    return c:IsRace(RACE_FISH) and c:IsAbleToHand()
end