---------------------------------------------------------------------------------------------------------
--- FAIR GAME(172016026) 通常魔法
--- ①：对方回合的结束阶段，自己场上没有卡存在的场合，可以把手卡的这张卡展示。这个效果展示的卡在对方的抽卡阶段抽卡前送去墓地。
--- ②：为①效果而公开表示的这张卡送去墓地的场合，对下列每项而言，这张卡展示期间若自己未曾如此做，
---     对方选择手卡·场上1张卡送去墓地，或双方不能如此做直到对方回合结束（若对方曾如此做，改为你来选）：
--- ● 抽卡
--- ● 通常召唤
--- ● 特殊召唤
--- ● 卡的盖放
--- ● 攻击宣言
--- ● 效果的发动
--- ● 发动的怪兽效果的适用
--- ● 发动的魔法·陷阱卡的效果的适用
--- 提示文本：是否要展示FAIR GAME？、抽卡、通常召唤、特殊召唤、卡的盖放、攻击宣言、效果的发动、
---          发动的怪兽效果的适用、发动的魔法·陷阱卡的效果适用、选卡送去墓地、不能如此做
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------
-- Flag effects
-- bit 0: No use
-- bit 1: Draw
-- bit 2: Normal Summon
-- bit 3: Special Summon
-- bit 4: Set
-- bit 5: Attack announcement
-- bit 6: Trigger Effect
-- bit 7: Monster Effect Resolve
-- bit 8: Spell/Trap Effect Resolve
-- 0b010110011 = Enabled, already draw, normal summon, 
--               attack announcement, trigger effect,
--               and resolve monster effect.
---------------------------------------------------------

local s,id,o=GetID()
o=1e9

function s.initial_effect(c)
    -- show
	local e1=Effect.CreateEffect(c)
	e1:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
	e1:SetCode(EVENT_PHASE+PHASE_END)
	e1:SetProperty(EFFECT_FLAG_EVENT_PLAYER+EFFECT_FLAG_IMMEDIATELY_APPLY)
    e1:SetRange(LOCATION_HAND)
	e1:SetCountLimit(1)
	e1:SetCondition(s.showcon)
	e1:SetOperation(s.showop)
    c:RegisterEffect(e1)
    -- to grave
	local e2=Effect.CreateEffect(c)
	e2:SetType(EFFECT_TYPE_SINGLE+EFFECT_TYPE_CONTINUOUS)
	e2:SetCode(EVENT_TO_GRAVE)
	e2:SetOperation(s.op)
	c:RegisterEffect(e2)
end

function s.showcon(e,tp,eg,ep,ev,re,r,rp)
    return Duel.GetMatchingGroupCount(aux.TRUE,tp,LOCATION_ONFIELD,0,nil)==0 and (not e:GetHandler():IsPublic()) and Duel.GetTurnPlayer()==1-tp
end

function s.showop(e,tp,eg,ep,ev,re,r,rp)
    if not Duel.SelectYesNo(tp,aux.Stringid(id,0)) then return end
    Duel.Hint(HINT_CARD,0,id)
    -- be public
    local c=e:GetHandler()
	local e1=Effect.CreateEffect(c)
	e1:SetType(EFFECT_TYPE_SINGLE)
	e1:SetCode(EFFECT_PUBLIC)
	e1:SetReset(RESET_EVENT+RESETS_STANDARD)
	c:RegisterEffect(e1)
    -- discard
	local e2=Effect.CreateEffect(c)
	e2:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
	e2:SetCode(EVENT_PREDRAW)
	e2:SetCountLimit(1)
	e2:SetLabelObject(c)
    e2:SetCondition(s.discon)
	e2:SetOperation(s.disop)
	Duel.RegisterEffect(e2,tp)
    -- flag
    c:RegisterFlagEffect(id+o,RESET_EVENT+RESETS_STANDARD,0,1)
    c:RegisterFlagEffect(id,0,0,1,1)
    -- listen
    s.listen(c,EVENT_DRAW,1)
    s.listen(c,EVENT_SUMMON,2)
    s.listen(c,EVENT_SPSUMMON_SUCCESS,3)
    s.listen(c,EVENT_SSET,4)
    s.listen(c,EVENT_ATTACK_ANNOUNCE,5)
    s.listen(c,EVENT_CHAINING,6)
    s.listen(c,EVENT_CHAIN_SOLVED,7,s.monstercon)
    s.listen(c,EVENT_CHAIN_SOLVED,8,s.spellcon)
end

function s.listen(c,code,bit,con)
    local e=Effect.CreateEffect(c)
    e:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
    e:SetProperty(EFFECT_FLAG_CLIENT_HINT)
    e:SetRange(LOCATION_HAND)
    e:SetDescription(aux.Stringid(id,bit))
    e:SetCode(code)
    e:SetCountLimit(1)
    if bit==5 then 
        e:SetCondition(s.recordcon)
    elseif con==nil then
        e:SetCondition(s.recordcon1)
    else
        e:SetCondition(aux.AND(s.recordcon1,con))
    end
    e:SetOperation(s.counterop(bit))
    e:SetReset(RESET_EVENT+RESETS_STANDARD)
    c:RegisterEffect(e)
    if bit==5 then return end
    local eo=e:Clone()
    if con==nil then
        eo:SetCondition(s.recordcon2)
    else
        eo:SetCondition(aux.AND(s.recordcon2,con))
    end
    eo:SetProperty(nil)
    eo:SetOperation(s.counterop(bit+8))
    c:RegisterEffect(eo)
end

function s.counterop(bit)
    return function(e,tp,eg,ep,ev,re,r,rp)
        local c=e:GetHandler()
        local status=c:GetFlagEffectLabel(id)
        if status==nil then status=1 end
        c:SetFlagEffectLabel(id,status|(1<<bit))
        e:Reset()
    end
end

function s.monstercon(e,tp,eg,ep,ev,re,r,rp)
    return re:IsActiveType(TYPE_MONSTER)
end
function s.spellcon(e,tp,eg,ep,ev,re,r,rp)
    return re:IsHasType(EFFECT_TYPE_ACTIVATE) and re:IsActiveType(TYPE_SPELL+TYPE_TRAP)
end
function s.recordcon(e,tp,eg,ep,ev,re,r,rp)
    local c=e:GetHandler()
    return c:GetFlagEffectLabel(id)~=nil and c:GetFlagEffect(id+o)>0
end
function s.recordcon1(e,tp,eg,ep,ev,re,r,rp)
    return s.recordcon(e,tp,eg,ep,ev,re,r,rp) and rp==tp
end
function s.recordcon2(e,tp,eg,ep,ev,re,r,rp)
    return s.recordcon(e,tp,eg,ep,ev,re,r,rp) and rp==1-tp
end

function s.discon(e,tp,eg,ep,ev,re,r,rp)
    return e:GetLabelObject():GetFlagEffect(id+o)>0 and Duel.GetTurnPlayer()==1-tp 
end
function s.disop(e,tp,eg,ep,ev,re,r,rp)
    local c=e:GetHandler()
    if c:GetFlagEffect(id+o)>0 then
        Duel.SendtoGrave(e:GetLabelObject(),REASON_EFFECT)
    end
end


function s.op(e,tp,eg,ep,ev,re,r,rp)
    local c=e:GetHandler()
    Duel.Hint(HINT_CARD,0,id)
    local code=c:GetFlagEffectLabel(id)
    c:ResetFlagEffect(id)
    if code==nil then
        return
    end
    local te=Effect.CreateEffect(c)
    te:SetType(EFFECT_TYPE_FIELD)
    te:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
    te:SetTargetRange(1,1)
    te:SetReset(RESET_PHASE+PHASE_END+RESET_OPPO_TURN)
    if s.select(code,tp,1) then
        local e1=te:Clone();
        e1:SetCode(EFFECT_CANNOT_DRAW)
        Duel.RegisterEffect(e1,tp)
    end
    if s.select(code,tp,2) then
        local e2=te:Clone();
        e2:SetCode(EFFECT_CANNOT_SUMMON)
        Duel.RegisterEffect(e2,tp)
    end
    if s.select(code,tp,3) then
        local e3=te:Clone();
        e3:SetCode(EFFECT_CANNOT_SPECIAL_SUMMON)
        Duel.RegisterEffect(e3,tp)
    end
    if s.select(code,tp,4) then
        local e4=te:Clone();
        e4:SetCode(EFFECT_CANNOT_MSET)
        Duel.RegisterEffect(e4,tp)
        local e4p=te:Clone();
        e4p:SetCode(EFFECT_CANNOT_SSET)
        Duel.RegisterEffect(e4p,tp)
    end
    if s.select(code,tp,5) then
        local e5=te:Clone();
        e5:SetCode(EFFECT_CANNOT_ATTACK_ANNOUNCE)
        Duel.RegisterEffect(e5,tp)
    end
    if s.select(code,tp,6) then
        local e6=te:Clone();
        e6:SetCode(EFFECT_CANNOT_ACTIVATE)
        e6:SetValue(aux.TRUE)
        Duel.RegisterEffect(e6,tp)
    end
    if s.select(code,tp,7) then
        local e7=Effect.CreateEffect(c)
        e7:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
        e7:SetCode(EVENT_CHAIN_SOLVING)
        e7:SetOperation(s.neop)
        e7:SetCondition(s.monstercon)
        e7:SetReset(RESET_PHASE+PHASE_END+RESET_OPPO_TURN)
        Duel.RegisterEffect(e7,tp)
    end
    if s.select(code,tp,8) then
        local e8=Effect.CreateEffect(c)
        e8:SetType(EFFECT_TYPE_FIELD+EFFECT_TYPE_CONTINUOUS)
        e8:SetCode(EVENT_CHAIN_SOLVING)
        e8:SetOperation(s.neop)
        e8:SetCondition(s.spellcon)
        e8:SetReset(RESET_PHASE+PHASE_END+RESET_OPPO_TURN)
        Duel.RegisterEffect(e8,tp)
    end
end

function s.select(code,tp,bit)
    if code&(1<<bit)>0 then return false end
    local p=1-tp
    if code&(1<<8<<bit)>0 then p=tp end
    if #Duel.GetMatchingGroup(Duel.IsAbleToGrave,tp,0,LOCATION_HAND+LOCATION_ONFIELD,nil)==0 then return true end
    Duel.SelectOption(p,aux.Stringid(id,bit))
    local option=Duel.SelectOption(p,aux.Stringid(id,9),aux.Stringid(id,10))
    if option==0 then
        local g=Duel.SelectMatchingCard(p,Duel.IsAbleToGrave,tp,0,LOCATION_HAND+LOCATION_ONFIELD,1,1,nil)
        Duel.SendtoGrave(g,REASON_RULE)
    end
    return option==1
end

function s.neop(e,tp,eg,ep,ev,re,r,rp)
    Duel.NegateEffect(ev,true)
end
