--懒趴的垃圾库
if lp then return end
local name = "Lanpa's library"
Debug.Message("You are using " .. name .. ".")
lp = lp or { } --"定义"
lc = lc or { } --"卡函数"
lg = lg or { } --"组函数"
le = le or { } --"效果函数"
lf = lf or { } --"支持函数"
la = aux --"Aux库函数"
lpname = lpname or { } --卡名
lpString = lpString or { } --string
ls=lpString
-----------------------------------------------------------"定义"
--attribute
lpatt = { }
lpatt.ea = ATTRIBUTE_EARTH --earth
lpatt.wa = ATTRIBUTE_WATER --water
lpatt.fr = ATTRIBUTE_FIRE --fire
lpatt.wd = ATTRIBUTE_WIND --wind
lpatt.lg = ATTRIBUTE_LIGHT --light
lpatt.da = ATTRIBUTE_DARK --dark
lpatt.all = lpatt.ea + lpatt.wa + lpatt.fr + lpatt.wd + lpatt.lg + lpatt.da

--location
lploc = { }
lploc.mv = LOCATION_MZONE+LOCATION_OVERLAY
lploc.hd = LOCATION_HAND+LOCATION_DECK 
lploc.hm = LOCATION_HAND+LOCATION_MZONE 
lploc.hs = LOCATION_HAND+LOCATION_SZONE
lploc.ho = LOCATION_HAND+LOCATION_ONFIELD
lploc.hg = LOCATION_HAND+LOCATION_GRAVE  
lploc.dg = LOCATION_DECK+LOCATION_GRAVE 
lploc.gr = LOCATION_GRAVE+LOCATION_REMOVED 
lploc.dgr = LOCATION_DECK+LOCATION_GRAVE+LOCATION_REMOVED 
lploc.hdg = LOCATION_HAND+LOCATION_DECK+LOCATION_GRAVE 
lploc.de = LOCATION_DECK+LOCATION_EXTRA
lploc.mg = LOCATION_MZONE+LOCATION_GRAVE 
lploc.og = LOCATION_ONFIELD+LOCATION_GRAVE 
lploc.hmg = LOCATION_HAND+LOCATION_MZONE+LOCATION_GRAVE 
lploc.hog = LOCATION_HAND+LOCATION_ONFIELD+LOCATION_GRAVE 
lploc.hdm = LOCATION_HAND+LOCATION_DECK+LOCATION_MZONE
lploc.all = lploc.de+lploc.ho+lploc.gr

--desc
desc = { }
desc.typ = 1170
desc.xyz = 1165

--type
lptyp = { }
lptyp.m = TYPE_MONSTER
lptyp.n = TYPE_NORMAL
lptyp.e = TYPE_EFFECT
lptyp.d = TYPE_DUAL
lptyp.u = TYPE_UNION
lptyp.to = TYPE_TOON
lptyp.tun = TYPE_TUNER
lptyp.dtun = TYPE_DARKTUNER
lptyp.rit = TYPE_RITUAL
lptyp.fus = TYPE_FUSION
lptyp.syn = TYPE_SYNCHRO
lptyp.dsyn = TYPE_DARKSYNCHRO
lptyp.xyz = TYPE_XYZ
lptyp.link = TYPE_LINK
lptyp.tok = TYPE_TOKEN
lptyp.pen = TYPE_PENDULUM
lptyp.sp = TYPE_SPSUMMON
lptyp.fl = TYPE_FLIP
lptyp.spi  = TYPE_SPIRIT
lptyp.s = TYPE_SPELL
lptyp.equ = TYPE_EQUIP
lptyp.f = TYPE_FIELD
lptyp.con = TYPE_CONTINUOUS
lptyp.q = TYPE_QUICKPLAY
lptyp.t = TYPE_TRAP
lptyp.counter = TYPE_COUNTER
lptyp.tm = TYPE_TRAPMONSTER
lptyp.st = lptyp.s + lptyp.t
lptyp.fsx = lptyp.fus + lptyp.syn +lptyp.xyz
lptyp.extra = lptyp.fus + lptyp.syn + lptyp.xyz + lptyp.link

--summon type
sptyp = { }
sptyp.n = SUMMON_TYPE_NORMAL
sptyp.a = SUMMON_TYPE_ADVANCE
sptyp.d = SUMMON_TYPE_DUAL
sptyp.f = SUMMON_TYPE_FLIP
sptyp.sp = SUMMON_TYPE_SPECIAL
sptyp.rit = SUMMON_TYPE_RITUAL
sptyp.fus = SUMMON_TYPE_FUSION
sptyp.syn = SUMMON_TYPE_SYNCHRO
sptyp.dsyn = SUMMON_TYPE_DARKSYNCHRO
sptyp.xyz = SUMMON_TYPE_XYZ
sptyp.pen = SUMMON_TYPE_PENDULUM
sptyp.link = SUMMON_TYPE_LINK
function sptyp.extra(c)
    local typ=c:GetSummonType()
    return typ==sptyp.fus or typ==sptyp.syn or typ==sptyp.xyz or typ==sptyp.link
end

--race
lprac ={ }
lprac.war = RACE_WARRIOR --战士
lprac.spe = RACE_SPELLCASTER --魔法师
lprac.fai = RACE_FAIRY --天使
lprac.fie = RACE_FIEND --恶魔
lprac.zom = RACE_ZOMBUE --不死
lprac.mac = RACE_MACHINE --机械
lprac.aqu = RACE_AQUA --水
lprac.pyr = RACE_PYRO --炎
lprac.roc = RACE_ROCK --岩石
lprac.win = RACE_WINDBEAST --鸟兽
lprac.pla = RACE_PLANT --植物
lprac.ins = RACE_INSECT --昆虫
lprac.thu = RACE_THUNER --雷
lprac.dag = RACE_DRAGON --龙
lprac.bea = RACE_BEAST --兽
lprac.beawar = RACE_BEASTWARRIOR --兽战士
lprac.din = RACE_DINOSAUR --恐龙
lprac.fis = RACE_FISH --鱼
lprac.sea = RACE_SEASERPENT --海龙
lprac.rep = RACE_REPTILE --爬虫类
lprac.psy = RACE_PSYCH --念动力
lprac.dev = RACE_DEVINE --幻神兽
lprac.cre = RACE_CREATORGOD --创造神
lprac.wyr = RACE_WYRM --幻龙
lprac.cyb = RACE_CYBERSE --电子界
lprac.all = RACE_ALL --全部种族

--reason
rea = { }
rea.cost = REASON_COST
rea.eff = REASON_EFFECT
rea.rul = REASON_RULE
rea.bat = REASON_BATTLE
rea.mat = REASON_MATERIAL
rea.rel = REASON_RELEASE
rea.rit = REASON_RITUAL
rea.fus = REASON_FUSION
rea.syn = REASON_SYNCHRO
rea.xyz = REASON_XYZ
rea.link = REASON_LINK
rea.rep = REASON_REPLACE
rea.rev = REASON_REVEAL
rea.ret = REASON_RETURN
rea.draw = REASON_DRAW
rea.dis = REASON_DISCARD
rea.sp = REASON_SPSUMMON
rea.des = REASON_DESTROY
rea.lost = REASON_LOST_TARGET
rea.loso = REASON_LOST_OVERLAY

--category 变量
lp.cat = {
	["SH"] = 0x20008	, --CATEGORY_SEARCH+CATEGORY_TOHAND
	--
	["S"] = CATEGORY_SUMMON   ,
	["SP"] = CATEGORY_SPECIAL_SUMMON	,
	["DSS"] = CATEGORY_DISABLE_SUMMON   ,
	["LG"] = CATEGORY_LEAVE_GRAVE       ,
	["SE"] = CATEGORY_SEARCH        ,
	["TD"] = CATEGORY_TODECK   ,
	["TG"] = CATEGORY_TOGRAVE  ,
	["TH"] = CATEGORY_TOHAND   ,
	["TE"] = CATEGORY_TOEXTRA   ,
	["RE"] = CATEGORY_TOREMOVE   ,
	["DES"]= CATEGORY_DESTROY ,
	["SPTH"] = CATEGORY_SPECIAL_SUMMON+CATEGORY_TOHAND	,
	["DIS"] = CATEGORY_DISABLE  ,
	["DISTG"] = CATEGORY_DISABLE+CATEGORY_TOGRAVE   ,
	["FSP"] = CATEGORY_SPECIAL_SUMMON+CATEGORY_FUSION_SUMMON    ,
	["CTRL"] = CATEGORY_CONTROL         ,
	["DM"] = CATEGORY_DAMAGE    ,
	["HAND"] = CATEGORY_HANDES  ,
	["TOKEN"] = CATEGORY_TOKEN      ,
	["COU"] = CATEGORY_COUNTER    ,
	["EQU"] = CATEGORY_EQUIP    ,
	["CA"] = CATEGORY_ATKCHANGE       ,
	["CD"] = CATEGORY_DEFCHANGE       ,
	["PS"] = CATEGORY_POSITION      ,
	["RC"] = CATEGORY_RECOVER       ,
}
--type 变量
lp.typ = {
    ["I"] = EFFECT_TYPE_IGNITION     ,
    ["ACT"] = EFFECT_TYPE_ACTIVATE      ,
    ["S"] = EFFECT_TYPE_SINGLE      ,
    ["F"] = EFFECT_TYPE_FIELD       ,
    ["QO"] = EFFECT_TYPE_QUICK_O        ,
    ["QF"] = EFEFCT_TYPE_QUICK_F        ,
    ["TO"] = EFFECT_TYPE_TRIGGER_O      ,
    ["TF"] = EFFECT_TYPE_TRIGGER_F      ,
    ["C"] = EFFECT_TYPE_CONTINUOUS      ,
    ["G"] = EFFECT_TYPE_GRANT       ,   
}
--code 变量
lp.cod = {
	--other
	["BS"] = EVENT_PHASE+PHASE_BATTLE_START     ,
	["BAST"] = EVENT_BATTLE_START       ,
	["SB"] = EVENT_PHASE+PHASE_STANDBY  ,
	["DSE"] = EVENT_DAMAGE_STEP_END     ,
	["FC"] = EVENT_FREE_CHAIN   ,
	["ADJ"] = EVENT_ADJUST  ,
    ["END"] = EVENT_PHASE+PHASE_END     ,
    ["CHNG"] = EVENT_CHAIN_NEGATED  ,
    ["CHDS"] = EVENT_CHAIN_DISABLED     ,
	--to location
	["TD"] = EVENT_TO_DECK   ,
	["TG"] = EVENT_TO_GRAVE  ,
	["TH"] = EVENT_TO_HAND   ,
	["RE"] = EVENT_REMOVE   ,
	["PS"] = EVENT_SUMMON   ,
	["SS"] = EVENT_SUMMON_SUCCESS   ,
	["PSP"] = EVENT_SPSUMMON   ,
	["SP"] = EVENT_SPSUMMON_SUCCESS   ,
	["BM"] = EVENT_BE_MATERIAL  ,
	["LF"] = EVENT_LEAVE_FIELD  ,
	["ING"] = EVENT_CHAINING  ,
	["EBAD"] = EVENT_BATTLE_DESTROYING      ,
	["ATKAN"] = EVENT_ATTACK_ANNOUNCE   ,
	["EDST"] = EVENT_DESTROYED      ,
	["BEST"] = EVENT_BATTLE_DESTROYED   ,
	["BBATG"] = EVENT_BE_BATTLE_TARGET  ,
	--effect
	["DIS"] = EFFECT_DISABLE        ,
	["DISE"] = EFFECT_DISABLE_EFFECT    ,
	["ESC"] = EFFECT_SPSUMMON_CONDITION     ,
	["IND"] = EFFECT_INDESTRUCTABLE_EFFECT  ,
	["INC"] = EFFECT_INDESTRUCTABLE_COUNT   ,
	["CNA"] = EFFECT_CANNOT_ACTIVATE    ,
	["SPOC"] = EFFECT_SPSUMMON_PROC    ,
	["CNS"] = EFFECT_CANNOT_SUMMON  ,
	["CNP"] = EFFECT_CANNOT_SPECIAL_SUMMON  ,
	["CNRM"] = EFFECT_CANNOT_REMOVE     ,
	["CTT"] = EFFECT_CANNOT_TRIGGER     ,
	["MUZ"]  = EFFECT_MUST_USE_MZONE     ,
	["INB"] = EFFECT_INDESTRUCTABLE_BATTLE  ,
	["CRM"] = EFFECT_CANNOT_REMOVE      ,
	["BATK"] = EFFECT_SET_BASE_ATTACK   ,
	["BDEF"] = EFFECT_SET_BASE_DEFENSE   ,
	["FATK"] = EFFECT_SET_ATTACK_FINAL  ,
	["FDEF"] = EFFECT_SET_DEFENSE_FINAL     ,
	["NATK"] = EFFECT_CANNOT_ATTACK     ,
	["EATK"] = EFFECT_EXTRA_ATTACK_MONSTER      ,
	["UPATK"] = EFFECT_UPDATE_ATTACK    ,
	["ALATK"] = EFFECT_ATTACK_ALL       ,
	["UPDEF"] = EFFECT_UPDATE_DEFENSE       ,
	["PUB"] = EFFECT_PUBLIC     ,
	["FUM"] = EFFECT_FUSION_MATERIAL    ,
	["IMM"] = EFFECT_IMMUNE_EFFECT  ,
	["CNTH"] = EFFECT_CANNNOT_TO_HAND    ,
	["CGRAS"] = EFFECT_CHANGE_RACE  ,
	["CNFM"] = EFFECT_CANNOT_BE_FUSION_MATERIAL     ,
	["CNSM"] = EFFECT_CANNOT_BE_SYNCHRO_MATERIAL        ,
	["CNXM"] = EFFECT_CANNOT_BE_XYZ_MATERIAL     ,
	["NBLM"] = EFFECT_CANNOT_BE_LINK_MATERIAL   ,
	["MATCHE"] = EFFECT_MATERIAL_CHECK  ,
	["CNDP"] = EFFECT_CANNOT_DISABLE_SPSUMMON   ,
	["CNBE"] =  EFFECT_CANNOT_BE_BATTLE_TARGET  ,
	["LFR"] = EFFECT_LEAVE_FIELD_REDIRECT        ,
	["FM"] = EFFECT_FUSION_MATERIAL     ,
	["EQL"] = EFFECT_EQUIP_LIMIT         ,
	["CATT"] = EFFECT_CHANGE_ATTRIBUTE      ,
	["ABD"] = EFFECT_AVOID_BATTLE_DAMAGE    ,
	["CETG"] = EFFECT_CANNOT_BE_EFFECT_TARGET     ,
	["CEBG"] = EFFECT_CANNOT_SELECT_BATTLE_TARGET       ,
	["PR"] = EFFECT_PIERCE      ,
	["ADDT"] = EFFECT_ADD_TYPE    ,
	["CAGL"] = EFFECT_CHANGE_LEVEL  ,
	["CAGR"] = EFFECT_CHANGE_RANK   ,
	["TGR"] = EFFECT_TO_GRAVE_REDIRECT  ,
}
--property 变量
lp.pro = {
	["TG"] = EFFECT_FLAG_CARD_TARGET   ,    --取对象效果
	["CTG"] = EFFECT_FLAG_CONTINUOUS_TARGET     ,
	["DE"] = EFFECT_FLAG_DELAY  ,   --场合形诱发效果
	["SR"] = EFFECT_FLAG_SINGLE_RANGE   ,   --影响区域效果
	["HINT"] = EFFECT_FLAG_CLIENT_HINT   ,  --客户端提示
	["PY"] = EFFECT_FLAG_PLAYER_TARGET   ,  --对玩家效果
	["OE"] = 17408   , --EFFECT_FLAG_CANNOT_DISABLE+EFFECT_FLAG_UNCOPYABLE 即无种类效果
	["SOE"] = 17408+EFFECT_FLAG_SINGLE_RANGE    ,   --不能无效的影响区域效果
	["POE"] = 17408+EFFECT_FLAG_PLAYER_TARGET    ,   --不能无效的对玩家效果
	["DETG"] = EFFECT_FLAG_CARD_TARGET+EFFECT_FLAG_DELAY    , --取对象场合形诱发效果
	["DM"] = EFFECT_FLAG_DAMAGE_STEP+EFFECT_FLAG_DAMAGE_CAL     , --可以伤害计算时发动的效果
	["DS"] = EFFECT_FLAG_DAMAGE_STEP   ,
	["DC"] = EFFECT_FLAG_DAMAGE_CAL     ,
	["SET"] = EFFECT_FLAG_SET_AVAILABLE     ,--影响场上里侧的卡/里侧状态可发动
	["EP"] = EFFECT_FLAG_EVENT_PLAYER   , --视为对方玩家的效果
	["CD"] = EFFECT_FLAG_CANNOT_DISABLE     ,--不会被无效的效果
	["IMM"] = EFFECT_FLAG_IGNORE_IMMUNE     ,--无视效果免疫的效果
}
--Location 变量
lp.ran = {
	["H"] = LOCATION_HAND   ,
	["D"] = LOCATION_DECK   ,
	["G"] = LOCATION_GRAVE  ,
	["R"] = LOCATION_REMOVED,
	["E"] = LOCATION_EXTRA  ,
	["M"] = LOCATION_MZONE  ,
	["S"] = LOCATION_SZONE  ,
	["F"] = LOCATION_FZONE  ,
	["O"] = LOCATION_OVERLAY,
	["P"] = LOCATION_PZONE  ,
	["MH"] = lploc.hm   ,
	["MV"] = lploc.mv   ,
	["HD"] = lploc.hd   ,
	["HS"] = lploc.hs   ,
	["HO"] = lploc.ho   ,
	["HG"] = lploc.hg   ,
	["DG"] = lploc.dg   ,
	["GR"] = lploc.gr       ,
	["DGR"] = lploc.dgr     ,
	["HDG"] = lploc.hdg     ,
	["DE"] = lploc.de  ,
	["MG"] = lploc.mg   ,
	["OG"] = lploc.of       ,
	["HMG"] = lploc.hmg ,
	["HOG"] = lploc.hog         ,
	["HDM"] = lploc.hdm     ,
	["FL"] = LOCATION_ONFIELD   ,
	["ALL"] = lploc.all     ,
}
--Phase 变量
lp.pha = {
	["DP"] = PHASE_DRAW   ,  --抽卡阶段
	["SP"] = PHASE_STANDBY  ,  --准备阶段
	["M1"] = PHASE_MAIN1		,  --主要阶段1
	["BPS"]= PHASE_BATTLE_START ,  --战斗阶段开始
	["BP"] = PHASE_BATTLE_STEP  ,  --战斗步骤
	["DA"] = PHASE_DAMAGE   ,  --伤害步骤
	["DC"] = PHASE_DAMAGE_CAL   ,  --伤害计算时
	["BPE"]= PHASE_BATTLE   ,  --战斗阶段结束
	["M2"] = PHASE_MAIN2		,  --主要阶段2
	["ED"] = PHASE_END  ,  --结束阶段
	["M"] = PHASE_MAIN  , --主要阶段
}
--Reset 变量
lp.res = {
    ["ST"] = RESET_EVENT+RESETS_STANDARD    ,
    ["END"] = RESET_PHASE+PHASE_END     ,
    ["SEND"] = RESET_EVENT+RESETS_STANDARD+RESET_PHASE+PHASE_END    ,
    ["CHA"] = RESET_CHAIN   ,
    ["PBS"] = RESET_PHASE+PHASE_BATTLE_STEP ,
    ["SCHA"] = RESET_EVENT+RESETS_STANDARD+RESET_CHAIN       ,
    ["TS"] = RESET_TURN_SET ,
}
--count limit 变量
lp.ctl = {
	["O"] = EFFECT_COUNT_CODE_OATH  ,  --发动次数
	["D"] = EFFECT_COUNT_CODE_DUEL  ,  --决斗次数
	["S"] = EFFECT_COUNT_CODE_SINGLE  ,  --公共次数
	["C"] = EFFECT_COUNT_CODE_CHAIN     ,
}
--Duel  函数
function lp.due(msg,...)
   if msg == "EMC" then return lf.IsExistingMatchingCard(...)
   elseif msg == "ET"  then return lf.IsExistingTarget(...)
   elseif msg == "SO" then return lf.SetOperationInfo(...)
   elseif msg == "GMG" then return lf.GetMatchingGroup(...)
    elseif msg =="SMC" then return lf.SelectMatchingCard(...) 
    elseif msg =="GFG" then return lf.GetFieldGroup(...)
    elseif msg =="GFGC" then return lf.GetFieldGroupCount(...) 
    elseif msg =="ST" then return lf.SelectTarget(...)  
    elseif msg =="RFE" then return lf.RegisterFlagEffect(...)       
    elseif msg =="HINT" then return lf.Hint(...)    
    elseif msg =="GN" then return lf.GetName(...)   
    elseif msg =="gn" then return lf.getname(...)   
    elseif msg =="Rm" then return lf.RemoveMore(...)    
    elseif msg =="GLC" then return Duel.GetLocationCount(...)    
    elseif msg =="SP" then return Duel.SpecialSummon(...)   
    elseif msg =="PLP" then return Duel.PayLPCost(...)
    elseif msg =="SYNP" then return Duel.SynchroSummon(...) 
    elseif msg =="XYZP" then return Duel.XyzSummon(...) 
    elseif msg =="LINKP" then return Duel.LinkSummon(...)
    elseif msg =="SS" then return Duel.Summon(...)      
    elseif msg =="SST" then return Duel.SSet(...)
    elseif msg =="TH" then return Duel.SendtoHand(...)      
    elseif msg =="TG" then return Duel.SendtoGrave(...)     
    elseif msg =="TD" then return Duel.SendtoDeck(...) 
    elseif msg =="TEP" then return Duel.SendtoExtraP(...)   
    elseif msg =="RM" then return Duel.Remove(...)      
    elseif msg =="DES" then return Duel.Destroy(...)    
    elseif msg =="DM" then return Duel.Damage(...)
    elseif msg =="SSEQ" then return Duel.SwapSequence(...)
    elseif msg =="GFT" then return Duel.GetFirstTarget(...)
    elseif msg =="STC" then return Duel.SetTargetCard(...)
    elseif msg =="CD" then return Duel.ConfirmDecktop(...)
    elseif msg =="GCD" then return Duel.GetDecktopGroup(...)
    elseif msg =="DD" then return Duel.DiscardDeck(...)
    elseif msf =="DSC" then return Duel.DisableShuffleCheck(...)
    elseif msg =="O" then return Duel.Overlay(...)     
    elseif msg =="NS" then return Duel.NegateSummon(...)
    elseif msg =="CC" then return Duel.ConfirmCards(...)    
    elseif msg =="SH" then return Duel.ShuffleHand(...) 
    elseif msg =="BK" then return Duel.BreakEffect(...) 
    elseif msg =="GC" then return Duel.GetChainInfo(...)    
    elseif msg =="GCC" then return Duel.GetCurrentChain(...)
    elseif msg =="PCDD" then return Duel.IsPlayerCanDiscardDeck(...)
    elseif msg =="GCP" then return Duel.GetCurrentPhase(...)
    elseif msg =="RE" then return Duel.RegisterEffect(...)      
    elseif msg =="ISC" then return Duel.IsSummonCancelable(...)     
    elseif msg =="ADJ" then return Duel.AdjustInstantly(...)
    elseif msg == "STPY" then return Duel.SetTargetPlayer(...)
    elseif msg =="STPA" then return Duel.SetTargetParam(...)
    elseif msg =="SSC" then return Duel.SetSelectedCard(...)    
    elseif msg =="GFE" then return Duel.GetFlagEffect(...)  
    elseif msg =="GLCME" then return Duel.GetLocationCountFromEx(...)   
    elseif msg =="GMZC" then return Duel.GetMZoneCount(...)
    elseif msg =="GCAC" then return Duel.GetCustomActivityCount(...)
    elseif msg =="GTP" then return Duel.GetTurnPlayer(...)  
    elseif msg =="SYN" then return Duel.SelectYesNo(...)
    elseif msg =="SE" then return Duel.ShuffleExtra(...)
    elseif msg =="SH" then return Duel.ShuffleHand(...)
    elseif msg =="SFM" then return Duel.SelectFusionMaterial(...)  
    elseif msg =="ICD" then return Duel.IsChainDisablable(...)
    elseif msg=="NE" then return Duel.NegateEffect(...)
    elseif msg=="GA" then return Duel.GetAttacker(...)
    elseif msg=="ACAC" then return Duel.AddCustomActivityCounter(...)
    elseif msg=="GCAC" then return GetCustomActivityCount(...)
    elseif msg=="HS" then return Duel.HintSelection(...) end
end
--Hintmsg 变量
lp.msg = {
    --hint
    ["E"] = HINT_EVENT      ,
    ["M"] = HINT_MESSAGE   ,
    ["S"] = HINT_SELECTMSG     ,
    ["OP"] = HINT_OPSELECTED        ,
    ["F"] = HINT_EFFECT     ,
    ["R"] = HINT_RACE   ,
    ["A"] = HINT_ATTRIB     ,
    ["O"] = HINT_CODE   ,
    ["N"] = HINT_NUMBER     ,
    ["C"] = HINT_CARD   ,
    --hintmsg
    ["RE"] = HINTMSG_RELEASE        ,
    ["DC"] = HINTMSG_DISCSRD    ,
    ["DES"] = HINTMSG_DESTROY   ,
    ["RM"] = HINTMSG_REMOVE ,
    ["TG"] = HINTMSG_TOGRAVE    ,
    ["RTH"] = HINTMSG_RTOHAND   ,
    ["ATH"] = HINTMSG_ATOHAND   ,
    ["TD"] = HINTMSG_TODECK ,
    ["SS"] = HINTMSG_SUMMON ,
    ["SP"] = HINTMSG_SPSUMMON   ,
    ["ST"] = HINTMSG_SET    ,
    ["FM"] = HINTMSG_FMATERIAL  ,
    ["SM"] = HINTMSG_SMATERIAL  ,
    ["XM"] = HINTMSG_XMATERIAL  ,
    ["LM"] = HINTMSG_LMATERIAL  ,
    ["FU"] = HINTMSG_FACEUP ,
    ["FD"] = HINTMSG_FACEDOWN   ,
    ["ATK"] = HINTMSG_ATTACK    ,
    ["DEF"] = HINTMSG_DEFENSE    ,
    ["EQ"] = HINTMSG_EQUIP      ,
    ["RX"] = HINTMSG_REMOVEXYZ  ,
    ["CT"] = HINTMSG_CONTRAL    ,
    ["DR"] = HINTMSG_DESREPLACE     ,
    ["UATK"] = HINTMSG_FACEUPATTACK ,
    ["UDEF"] = HINTMSG_FACEUPDEFENSE    ,
    ["DATK"] = HINTMSG_FACEDOWNATTACK ,
    ["DDEF"] = HINTMSG_FACEDOWNDEFENCE  ,
    ["CF"] = HINTMSG_CONFIRM    ,
    ["TF"] = HINTMSG_TOFIELD    ,
    ["PS"] = HINTMSG_POSCHANGE  ,
    ["SF"] = HINTMSG_SELF       ,
    ["PP"] = HINTMSG_OPPO   ,
    ["TB"] = HINTMSG_TRIBUTE    ,
    ["DF"] = HINTMSG_DEATTACHFROM   ,
    ["ATAG"] = HINTMSG_ATTACKTATGET ,
    ["MF"] = HINTMSG_EFFECT     ,
    ["TAG"] = HINTMSG_TARGET    ,
    ["CN"] = HINTMSG_COIN   ,
    ["DI"] = HINTMSG_DICE   ,
    ["CY"] = HINTMSG_CARDTYPE  ,
    ["ON"] = HINTMSG_OPTION ,
    ["REF"] = HINTMSG_RESOLVEEFFECT ,
    ["SEL"] = HINTMSG_SELECT    ,
    ["POS"] = HINTMSG_POSITION  ,
    ["MA"] = HINTMSG_ATTRIBUTE ,
    ["MR"] = HINTMSG_RACE   ,
    ["MO"] = HINTMSG_CODE       ,
    ["REC"] = HINTMSG_RESOLVECARD   ,
    ["ZO"] = HINTMSG_ZONE       ,
}
--Effect 函数
function lp.E(e,eff,...)
    if eff == "CRE" then return Effect.CreateEffect(...) 
    elseif eff == "DES" then return e:SetLPDescription(...)
    elseif eff == "CAT" then return e:SetLPCategory(...)
    elseif eff == "TYP" then return e:SetLPType(...)
    elseif eff == "COD" then return e:SetLPCode(...)
    elseif eff == "CTL" then return e:SetLPCountLimit(e,...)
    elseif eff == "PRO" then return e:SetLPProperty(...)
    elseif eff == "RAN" then return SetLPRange(...)
    elseif eff == "CON" then return e:SetCondition(...)
    elseif eff == "COS" then return e:SetCost(...)
    elseif eff == "TG" then return e:SetTarget(...)
    elseif eff == "OP" then return e:SetOperation(...)
    elseif eff == "VAL" then return e:SetValue(...)
    elseif eff == "RES" then return e:SetLPReset(...)
    elseif eff == "TRAN" then return e:SetLPTargetRange(...)
    elseif eff == "LAB" then return e:SetLabel(...)
    elseif eff == "OBJ" then return e:SetLabelObject(...)
    elseif eff == "CLO" then return e:SetClone()
    elseif eff == "GLO" then return Effect.GlobalEffect(...)
    elseif eff == "SOP" then return le.SelectOption(...)
    elseif eff == "RFE" then return le.RegisterFlagEffect(...)
    elseif eff == "SL" then return e:SetLabel(...)
    elseif eff == "GL" then return e:GetLabel(...)
    elseif eff == "SO" then return e:SetLabelObject(...)
    elseif eff == "GO" then return e:GetLabelObject(...)
    elseif eff == "GH" then return e:gc() 
    elseif eff == "GHP" then return e:GetHandlerPlayer(...)
    elseif eff=="GW" then return e:GetOwner(...) 
    elseif eff=="ESC" then return e:Reset(...) end
end
--Effect 变量
lp.eff = {
	CRE   = Effect.CreateEffect,
	DES   = function(e,...) if lf.Not_All_nil(...) then Effect.SetLPDescription(e,...) end end,
	CAT   = function(e,v) if v then Effect.SetLPCategory(e,v) end end,
	TYP   = function(e,v) if v then Effect.SetLPType(e,v) end end,
	COD   = function(e,v) if v then Effect.SetLPCode(e,v) end end,
	CTL   = function(e,...) if lf.Not_All_nil(...) then Effect.SetLPCountLimit(e,...) end end,
	PRO   = function(e,...) if lf.Not_All_nil(...) then Effect.SetLPProperty(e,...) end end,
	RAN   = function(e,v) if v then Effect.SetLPRange(e,v) end end,
	CON   = Effect.SetCondition,
	COS   = Effect.SetCost,
	TG  = Effect.SetTarget,
	OP  = Effect.SetOperation,
	VAL   = Effect.SetValue,
	RES   = function(e,...) if lf.Not_All_nil(...) then Effect.SetLPReset(e,...) end end,
	TRAN  = function(e,...) if lf.Not_All_nil(...) then Effect.SetLPTargetRange(e,...) end end,
	LAB   = function(e,...) if lf.Not_All_nil(...) then Effect.SetLabel(e,...) end end,
	LABOBJ= Effect.SetLabelObject,
	CLO   = Effect.Clone,
	GLO = Effect.GlobalEffect,
	DEG = Duel.RegisterEffect,
}
-------------------------------------------------------------------------------------------"卡函数"
function Card.Isloc(c,loc)
    return c:IsLocation(lp.ran[loc])
end
function Card.IsMloc(c,loc)
    return c:IsSummonLocation(lp.ran[loc])
end
function Card.LPAddCodeList(c,code)
    return aux.AddCodeList(c,code)
end
function Card.LPSetUniqueOnField(c)
    return c:SetUniqueOnField(1,0,c:GetOriginalCode())
end
function Card.AddNameList(c,...)
	if c:IsStatus(STATUS_COPYING_EFFECT) then return end
	if c.card_name_list==nil then
		local mt=getmetatable(c)
		mt.card_name_list={}
		for _,code in ipairs{...} do
		    local name=lf.getname(code)
			mt.card_name_list[name]=true
		end
	else
		for _,code in ipairs{...} do
		    local name=lf.getname(code)
			c.card_name_list[name]=true
		end
	end
end
function Card.AddNameList2(c,...)
	if c.card_name_list==nil then
		local mt=getmetatable(c)
		mt.card_name_list={}
		for _,code in ipairs{...} do
		    local name=lf.getname(code)
			mt.card_name_list[name]=true
		end
	else
		for _,code in ipairs{...} do
		    local name=lf.getname(code)
			c.card_name_list[name]=true
		end
	end
end
function Card.IsName(c,name)
    local cname = lf.GetName(c)
    return cname == name
end
function Card.Isname(c,name)
    local cname = lf.GetName(c)
    return cname == name
end
function Card.Isnamelist(c,code)
    local name=lf.getname(code)
	return c.card_name_list and c.card_name_list[name]
end
function Card.IsNameList(c,code)
    local name=lf.GetName(code)
	return c.card_name_list and c.card_name_list[name]
end
function lc.CopyEffect(c,code,res,ct)
    return c:CopyEffect(code,lp.res[res],ct)
end
function lc.darkf(c)
    if c:GetSynchroType()==lptyp.xyz or c:GetSynchroType()==lptyp.link then return false end
    return c:IsLevelAbove(1)
end
function lc.IsDarkSynchroSummon(c)
    return c:GetFlagEffect(1145141)>0 and lc.IsDarkSynchro(c)
end
function lc.IsDarkSynchro(c)
	return lc.DarkSynchro(c)
end
function lc.IsDarkTuner(c)
	return lc.DarkTuner(nil)(c)
end
function lc.DarkSynchro(c)
    local type_list = { c:IsHasEffect(lp.cod["ADDT"]) }
	local bool = false
	for _, e in pairs(type_list) do
        if lpString[e] =="TYPE_DARKSYNCHRO" then
		    bool = true
		    break 
		    end
		end
	return (c.dark_synchro or bool)
end
function lc.DarkTuner(f, ...)
	local ex_paramas = { ... }
	return  function(c)
				local type_list = { c:IsHasEffect(lp.cod["ADDT"]) }
				local bool = false
				for _, e in pairs(type_list) do
					if lpString[e] == "TYPE_DARKTUNER" then
						bool = true
					break 
					end
				end
				return (c.dark_tuner or bool) and aux.Tuner(f, table.unpack(ex_paramas))(c)
			end
end
function lc.IsSummonType(c,sptyp)
    return bit.band(c:GetSummonType(),sptyp)==sptyp
end
function lc.IsSummontypeIs(sumtype,sptyp)
    return bit.band(sumtype,sptyp)==sptyp
end
function lc.LConditionFilter(c,f,lc)
	return c:IsCanBeLinkMaterial(lc) and (not f or f(c))
end
function lc.CheckFusion(c,e,tp,mg,chkf)
    local res=c:IsCanBeSpecialSummoned(e,sptyp.fus,tp,false,false) and c:CheckFusionMaterial(mg,nil,chkf)
    return res
end
function lc.PConditionFilter(c,e,tp,lscale,rscale)
	local lv=0
	if c.pendulum_level then
		lv=c.pendulum_level
	else
		lv=c:GetLevel()
	end
	local bool=aux.PendulumSummonableBool(c)
	return (c:IsLocation(lp.ran["H"]) or (c:IsFaceup() and c:IsType(lptyp.pen)))
		and lv>lscale and lv<rscale and c:IsCanBeSpecialSummoned(e,sptyp.pen,tp,bool,bool)
		and not c:IsForbidden()
end
function lg.GetNumberCardInGroup(g,ct)
    local tc=0
    for i=1,ct do
        if i==1 then tc=g:GetFirst()
        elseif i>1 then tc=g:GetNext() end
    end
    return tc
end
function lc.GetLinkMarker(c)
    if not c:IsType(lptyp.link) then return false end
    local lk=0
    if c:IsLinkMarker(0x001) then lk=lk+0x001 end
    if c:IsLinkMarker(0x002) then lk=lk+0x002 end
    if c:IsLinkMarker(0x004) then lk=lk+0x004 end
    if c:IsLinkMarker(0x008) then lk=lk+0x008 end
    if c:IsLinkMarker(0x020) then lk=lk+0x020 end
    if c:IsLinkMarker(0x040) then lk=lk+0x040 end
    if c:IsLinkMarker(0x080) then lk=lk+0x080 end
    if c:IsLinkMarker(0x100) then lk=lk+0x100 end
    return lk --返回连接标记为dir
end
function Card.GetRcSystemPoint(c,tp)
    if not c:IsLocation(0x0c) then return false end
    local point={}
    local cp=c:GetControler()
    if cp==tp then cp=-1 else cp=1 end
    local loc=c:GetLocation()
    local seq=c:GetSequence()
    if loc==lp.ran["M"] then
        if seq<5 then
            point={(2-seq)*cp,1*cp}
        else
            point={((-2)*seq+11)*cp,0}
        end
    else
        if seq~=5 then
            point={(2-seq)*cp,2*cp}
        else
            point={3*cp,1*cp}
        end
    end
    return point
end
function Card.GetCardLine(c,tc,tp)
    if c==tc then return false end
    local cpoint=c:GetRcSystemPoint(tp)
    local tcpoint=tc:GetRcSystemPoint(tp)
    local j,k,p,q=cpoint[1],cpoint[2],tcpoint[1],tcpoint[2]
    return {q-k,j-p,k*p-j*q}
end
function Card.GetLinkMarkerSlope(c)
    if not c:IsType(lptyp.link) then return false end
    local slope=0
    --(k=-A/B)
    if c:IsLinkMarker(0x101) then slope=slope+0x1 end --A=-B
    if c:IsLinkMarker(0x082) then slope=slope+0x2 end --A=0
    if c:IsLinkMarker(0x044) then slope=slope+0x4 end --A=B
    if c:IsLinkMarker(0x028) then slope=slope+0x8 end --B=0
    if slope==0 then return false end
    return slope --返回箭头所指的方向
end
function Card.GetLinkedLine(c,tp)
    if not c:IsType(TYPE_LINK) then return false end
    local line={}
    local point=c:GetRcSystemPoint(tp)
    if not point then return false end
    if c:IsLinkMarker(0x101) then table.insert(line,{1,-1,(point[1]*(-1)+point[2]*(1)),point[1],point[2]}) end
    if c:IsLinkMarker(0x082) then table.insert(line,{1,0,(point[1]*(-1)),point[1],point[2]}) end
    if c:IsLinkMarker(0x044) then table.insert(line,{1,1,(point[1]*(-1)+point[2]*(-1)),point[1],point[2]}) end
    if c:IsLinkMarker(0x028) then table.insert(line,{0,1,(point[2]*(-1)),point[1],point[2]}) end
    return line
end
-------------------------------------------------------------------------------------------"组函数"
function lg.GetAllRoundCard(c)
    local rg=Group.CreateGroup()
    local tp=c:GetControler()
    local seq=c:GetSequence()
    local loc=c:GetLocation()
    local mg=c:GetColumnGroup()
    mg:Filter(Card.IsControler,nil,tp)
    local og=Duel.GetMatchingGroup(nil,tp,LOCATION_ONFIELD,0,nil)
    local seq1=seq+1
    local seq2=seq-1
    if seq>4 then return false end
    for tc in aux.Next(og) do
        if (tc:GetSequence()-seq==1 or seq-tc:GetSequence()==1) and not tc:GetSequence()>4 and tc:GetLocation()==loc then mg:AddCard(tc) end
    end
    return mg --返回c相邻的上下左右的所有卡
end
function lg.GetGroupLineGroup(cg)
    local rg=Group.CreateGroup()
    if #cg~=2 or cg:FilterCount(Card.IsLocation,nil,LOCATION_ONFIELD)~=2 then return rg end
    local g=Duel.GetMatchingGroup(aux.TRUE,tp,0x0c,0x0c,cg)
    if #g==0 then return rg end
    local c1,c2=cg:GetFirst(),cg:GetNext()
    local tp=c1:GetControler()
    local line=c1:GetCardLine(c2,tp)
    if #line==0 then return rg end
    local j,k,l=line[1],line[2],line[3]
    for rc in aux.Next(g) do
        local tpoint=rc:GetRcSystemPoint(tp)
        local p,q=tpoint[1],tpoint[2]
        if j==0 or k==0 then
            if (j*p+k*q+l)^2<0.25*(j*j+k*k) then rg:AddCard(rc) end
        else
            local spoint={{p-0.5,q-0.5},{p-0.5,q+0.5},{p+0.5,q-0.5},{p+0.5,q+0.5}}
            local zero,posn,negn=0,0,0
            for i in pairs(spoint) do
                local num=j*spoint[i][1]+k*spoint[i][2]+l
                if num==0 then
                    zero=zero+1
                elseif num>0 then
                    posn=posn+1
                else
                    negn=negn+1
                end
            end
            if posn*negn~=0 then rg:AddCard(rc) end
        end
    end
    return rg
end
function lg.GetLinkMaterials(tp,f,lc)
	local mg=Duel.GetMatchingGroup(lc.LConditionFilter,tp,lp.ran["M"],0,nil,f,lc)
	local mg2=Duel.GetMatchingGroup(Auxiliary.LExtraFilter,tp,lploc.hs,LOCATION_ONFIELD,nil,f,lc,tp)
	if mg2:GetCount()>0 then mg:Merge(mg2) end
	return mg
end
function lg.GetMultiLinkedHalfLineGroup(c,f,tp,...)
	local lg=Duel.GetMatchingGroup(f,tp,lp.ran["M"],lp.ran["M"],nil,...)
	local check=0
	for tc in aux.Next(lg) do
	    if not tc:IsType(lptyp.link) then return end
		local rlg=tc:GetLinkedHalfLineGroup()
		if rlg:IsContains(c) then
		    check=check+1
		end
	end
	return check --返回场上所有 f1 怪兽连接方向包含 c 的数量，从第四个参数开始是额外参数
end
function lg.GetGroupLinkedHalfLineGroup(g)
    local tc=g:GetFirst()
    local rg=Group.CreateGroup()
    while tc do
        local bg=tc:GetLinkedHalfLineGroup()
        if #bg>0 then
            rg:Merge(bg)
        end
        tc=g:GetNext()
    end
    return rg   --返回g中所有的连接方向组
end
function lg.GetGroupRelateBattle(g)
    local res=0
    for tc in aux.Next(g) do
        if tc:IsRelateToBattle() then
            res=res+1
        end
    end
    if res~=0 then return true
    else return false end
end
function lg.RemoveGroup(g1,g2)
    local tc=g2:GetFirst()
    while tc do
        g1:RemoveCard(tc)
        tc=g2:GetNext()
    end
    return g    --从g1中把g2的所有卡移除
end
function lg.GetLinkCount(g)
    local tc=g:GetFirst()
    local lk=0
    while tc do
        local lkk=0
        if tc:IsType(TYPE_LINK) then
            lkk=tc:GetLink()
        else
            lkk=1
        end
        lk=lk+lkk
        tc=g:GetNext()
    end
    return lk   --返回g组内的所有卡的连接值总和
end
function Card.GetLinkedHalfLineGroup(c)
    if not c:IsType(TYPE_LINK) then return false end
    local rg=Group.CreateGroup()
    local tp=c:GetControler()
    local g=Duel.GetMatchingGroup(aux.TRUE,tp,0x0c,0x0c,c)
    if #g==0 then return rg end
    local line=c:GetLinkedLine(tp)
    if not line then return rg end
    if #line==0 then return rg end 
    for tc in aux.Next(g) do
        local tpoint=tc:GetRcSystemPoint(tp)
        for i in ipairs(line) do
            if line[i][1]*tpoint[1]+line[i][2]*tpoint[2]+line[i][3]==0 then
                if line[i][1]-line[i][2]==1 then
                    if c:IsLinkMarker(0x080) and tpoint[2]-line[i][5]>0 then rg:AddCard(tc) end
                    if c:IsLinkMarker(0x002) and tpoint[2]-line[i][5]<0 then rg:AddCard(tc) end
                elseif line[i][1]-line[i][2]==-1 then
                    if c:IsLinkMarker(0x020) and tpoint[1]-line[i][4]>0 then rg:AddCard(tc) end
                    if c:IsLinkMarker(0x008) and tpoint[1]-line[i][4]<0 then rg:AddCard(tc) end
                elseif line[i][1]-line[i][2]==2 then
                    if c:IsLinkMarker(0x100) and tpoint[1]-line[i][4]>0 then rg:AddCard(tc) end
                    if c:IsLinkMarker(0x001) and tpoint[1]-line[i][4]<0 then rg:AddCard(tc) end
                elseif line[i][1]-line[i][2]==0 then
                    if c:IsLinkMarker(0x004) and tpoint[1]-line[i][4]>0 then rg:AddCard(tc) end
                    if c:IsLinkMarker(0x040) and tpoint[1]-line[i][4]<0 then rg:AddCard(tc) end
                end
            end
        end
    end
    return rg --返回连接方向组
end
-------------------------------------------------------------------------------------------"效果函数"
function le.Creat(owner,handler,...)
--创建效果
	--Delete nil
	local list = {...}
	local setlist = lf.DeleteNil(list)
	--Set and Register effect
	local e = le.Set(lp.eff.CRE(lf.GetCardTable(owner)[1]),table.unpack(setlist))
	if handler then le.Register(e,handler) end
	return e
end
function le.CreatPY(owner,tp,...)
--玩家创建效果
	--Delete nil
	local list = {...}
	local setlist = lf.DeleteNil(list)
	--Set and Register effect
	local e = le.Set(lp.eff.CRE(lf.GetCardTable(owner)[1]),table.unpack(setlist))
	if tp then lp.eff.DEG(e,tp) end
	return e
end
function le.Clone(e,handler,...)
--克隆效果
	--Delete nil
	local list = {...}
	local setlist = lf.DeleteNil(list)
	--Set and Register effect
	local e = le.Set(lp.eff.CLO(e),table.unpack(setlist))
	if handler then le.Register(e,handler) end
	return e
end
function le.Global(handler,tp,...)
--克隆效果
	--Delete nil
	local list = {...}
	local setlist = lf.DeleteNil(list)
	--Set and Register effect
	local ge = le.Set(lp.eff.GLO(handler),table.unpack(setlist))
	if tp then lp.eff.DEG(ge,tp) end
	return ge
end
function le.Set(e,...)
--Set Effect detail
	e = type(e) == "table" and e or { e }
	local setlist = {...}
	setlist = lf.DeleteNil(setlist)
	if #setlist == 0 then return table.unpack(e) end
	if type(setlist[1]) ~= "table" then setlist = {setlist} end
	for _,E in ipairs(e) do
		for _,set in ipairs(setlist) do
			local f = type(set[1]) == "string" and lp.eff[set[1] ] or set[1]
			table.remove(set,1)
			f(E,table.unpack(set))
		end
	end
	return table.unpack(e)
end
function le.Register(e,handler)
--Register Effect
	handler = type(handler) == "table" and handler or { handler }
	local Ignore = handler[2] or false
	local Handler = type(handler[1]) == "number" and handler[1] or lf.GetCardTable(handler[1])
	for _,E in ipairs(type(e) == "table" and e or {e}) do
		if type(Handler) == "number" then
			lf.RegEffect(E,Handler)
		else
			for _,C in ipairs(Handler) do
				C:RegisterEffect(E,Ignore)
			end
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------------------------
function Effect.SetLPDescription(e,...)
    Effect.SetDescription(lf.des(e,{...}))
end
function Effect.SetLPCategory(e,v)
    Effect.SetCategory(e,lf.cat(v))
end
function Effect.SetLPType(e,v)
    Effect.SetType(e,lf.typ(v))
end
function Effect.SetLPCode(e,v)
    Effect.SetCode(e,lf.cod(v))
end
function Effect.SetLPCountLimit(e,...)
    Effect.SetCountLimit(lf.ctl(e,{...}))
end
function Effect.SetLPProperty(e,...)
    Effect.SetProperty(e,lf.pro({...}))
end
function Effect.SetLPRange(e,v)
    Effect.SetRange(e,lf.Loc(v,1))
end
function Effect.SetLPReset(e,...)
    Effect.SetReset(e,lf.res({...}))
end
function Effect.SetLPTargetRange(e,...)
    Effect.SetTargetRange(e,lf.tran({...}))
end
function le.check(e,tp)
	local lpz=Duel.GetFieldCard(tp,lp.ran["P"],0)
	if lpz==nil then return false end
	local pcon=le.PendCondition
	return pcon(e,lpz,g)
end
function le.PendCondition()
	return  function(e,c,og)
				if c==nil then return true end
				if Duel.GetFieldGroupCount(tp,lp.ran["F"],0)<2 then return false end
				local tp=c:GetControler()
				local rpz=Duel.GetFieldCard(tp,lp.ran["P"],1)
				if rpz==nil or c==rpz then return false end
				local lscale=c:GetLeftScale()
				local rscale=rpz:GetRightScale()
				if lscale>rscale then lscale,rscale=rscale,lscale end
				local loc=0
				if Duel.GetLocationCount(tp,lp.ran["M"])>0 then loc=loc+lp.ran["H"] end
				if Duel.GetLocationCountFromEx(tp,tp,nil,lptyp.pen)>0 then loc=loc+lp.ran["E"] end
				if loc==0 then return false end
				local g=nil
				if og then
					g=og:Filter(Card.IsLocation,nil,loc)
				else
					g=Duel.GetFieldGroup(tp,loc,0)
				end
				return g:IsExists(lc.PConditionFilter,1,nil,e,tp,lscale,rscale)
			end
end
function le.RegisterFlagEffect(c, cod, res, pro, desc)
    if not cod then cod=c:GetOriginalCode() end
    if res then res=lf.res(res) end
    if pro then pro=lf.pro(pro) end
    return c:RegisterFlagEffect(cod,res,pro,1,0,desc) --为c注册一个标识用效果
end
function le.ptg(e,tp,eg,ep,ev,re,r,rp,chk)
	if chk==0 then return le.check(e,tp,nil) end
end
function le.pop(e,tp,eg,ep,ev,re,r,rp,sg,og)
	local lpz=Duel.GetFieldCard(tp,lp.ran["P"],0)
	if lpz==nil then return end
	--the summon should be done after the chain end
	local sg=Group.CreateGroup()
	local pspop=le.pspop
	pspop(e,tp,eg,ep,ev,re,r,rp,lpz,sg,nil)
	if Duel.SpecialSummon(sg,sptyp.pen,tp,tp,false,false,POS_FACEUP)~=0 then
		Duel.RaiseEvent(e:GetHandler(),EVENT_CUSTOM+15000727,re,r,rp,ep,ev)
	end
end
function le.pspop(e,tp,eg,ep,ev,re,r,rp,lpz,sg,og)
	local rpz=Duel.GetFieldCard(tp,lp.ran["P"],1)
	local lscale=lpz:GetLeftScale()
	local rscale=rpz:GetRightScale()
	if lscale>rscale then lscale,rscale=rscale,lscale end
	local eset={nil}
	local tg=nil
	local loc=0
	local ft1=Duel.GetLocationCount(tp,lp.ran["M"])
	local ft2=Duel.GetLocationCountFromEx(tp,tp,nil,lptyp.pen)
	local ft=Duel.GetUsableMZoneCount(tp)
	local ect=c29724053 and Duel.IsPlayerAffectedByEffect(tp,29724053) and c29724053[tp]
	if ect and ect<ft2 then ft2=ect end
	if Duel.IsPlayerAffectedByEffect(tp,59822133) then
		if ft1>0 then ft1=1 end
		if ft2>0 then ft2=1 end
		ft=1
	end
	if ft1>0 then loc=loc|lp.ran["H"] end
	if ft2>0 then loc=loc|lp.ran["E"] end
	if og then
		tg=og:Filter(Card.IsLocation,nil,loc):Filter(lc.PConditionFilter,nil,e,tp,lscale,rscale)
	else
		tg=Duel.GetMatchingGroup(lc.PConditionFilter,tp,loc,0,nil,e,tp,lscale,rscale)
	end
	local ce=nil
	Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_SPSUMMON)
	aux.GCheckAdditional=aux.PendOperationCheck(ft1,ft2,ft)
	local g=tg:SelectSubGroup(tp,aux.TRUE,true,1,math.min(#tg,ft))
	aux.GCheckAdditional=nil
	if not g then return end
	sg:Merge(g)
	lf.D("HS",Group.FromCards(lpz))
	lf.D("HS",Group.FromCards(rpz))
end
function le.splimit(sptyp)
    return function(e,se,sp,st)
	    return st&sptyp==sptyp
	end
end
function le.sptypcon(sptyp)
    return function(e)
        local c=e:GetHandler()
	    return lc.IsSummonType(c,sptyp)
	end
end
function le.battletg(e,tp,eg,ep,ev,re,r,rp,chk,chkc)
    --取对象伤害计算
	local c=e:GetHandler()
	if chkc then return chkc:IsControler(1-tp) and chkc:Isloc("M") end
	if chk==0 then return c:IsAttackable()
		and lf.IsExistingTarget(nil,tp,0,"M",1,nil) and c:GetFlagEffect(c:GetCode())==0 end
	le.RegisterFlagEffect(c, c:GetCode(), "CHA", nil, nil)
	lf.Hint("S",tp,"PP")
	local g=lf.SelectTarget(tp,nil,tp,0,"M",1,1,nil)
end
function le.battleop(e,tp,eg,ep,ev,re,r,rp)
    --取对象伤害计算
	local c=e:GetHandler()
	if c:IsAttackable() and c:IsControler(tp) and c:IsFaceup() and c:IsRelateToEffect(e) then
		local g=Duel.GetChainInfo(0,CHAININFO_TARGET_CARDS)
		local tc=g:GetFirst()
		if tc:IsControler(1-tp) and tc:IsRelateToEffect(e) then
			Duel.CalculateDamage(c,tc)
		end
	end
end
function le.paycost(ct)
    return function(e,tp,eg,ep,ev,re,r,rp,chk)
	    if chk==0 then return Duel.CheckLPCost(tp,ct) end
	    lf.D("PLP",tp,ct)
	end
end
function le.remove_overlay_cost(min,max)
    return function(e,tp,eg,ep,ev,re,r,rp,chk)
	    if chk==0 then return e:GetHandler():CheckRemoveOverlayCard(tp,min,rea.cost) end
	    e:GetHandler():RemoveOverlayCard(tp,min,max,rea.cost)
	end
	--取除这张卡 min - max 个超量素材
end
function le.EnableAddCode(c,code,location,condition)
	Auxiliary.AddCodeList(c,code)
	local loc=c:GetOriginalType()&lptyp.m~=0 and lp.ran["M"] or lp.rab["S"]
	loc=location or loc
	if condition==nil then condition=Auxiliary.TRUE end
	local e1=Effect.CreateEffect(c)
	e1:SetLPType("S")
	e1:SetLPProperty("SR")
	e1:SetCode(EFFECT_ADD_CODE)
	e1:SetRange(loc)
	e1:SetCondition(condition)
	e1:SetValue(code)
	c:RegisterEffect(e1)
	return e1
end
function le.EnableSpLimit(c,sptyp,tg)
    local e0=Effect.CreateEffect(c)
	e0:SetLPProperty("OE")
	e0:SetLPType({"S","TO"})
	e0:SetLPCode("SP")
	e0:SetCondition(le.regcon(sptyp))
	e0:SetOperation(le.regop(tg))
	c:RegisterEffect(e0)
	return e0 --为 c 添加 sptyp 的次数限制 ，限制对象为tg
end
function le.SelectOption(a,b,c,d,tp)
    local off=1
    local ops={}
    local opval={}
    if a then
    ops[off]=c
    opval[off]=0
    off=off+1
    end
    if b then
	    ops[off]=d
	    opval[off]=1
	    off=off+1
	end
	local op=Duel.SelectOption(tp,table.unpack(ops))+1
	local sel=opval[op]
	return sel
end
function le.RegisterMergedDelayedEvent(c,code,event,g)
    event=lp.cod[event]
    return la.RegisterMergedDelayedEvent(c,code,event,g)
end
function le.regcon(sptyp)
    return	function(e,tp,eg,ep,ev,re,r,rp)
        local c=e:GetHandler()
	    return lc.IsSummonType(c,sptyp)
	end
end
function le.regop(tg)
    return	function(e,tp,eg,ep,ev,re,r,rp)
        local e1=Effect.CreateEffect(e:GetHandler())
	    e1:SetType(EFFECT_TYPE_FIELD)
	    e1:SetCode(EFFECT_CANNOT_SPECIAL_SUMMON)
	    e1:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
	    e1:SetTargetRange(1,0)
	    e1:SetReset(RESET_PHASE+PHASE_END)
	    e1:SetTarget(tg)
	    Duel.RegisterEffect(e1,tp)
	end
end
-------------------------------------------------------------------------------------------------------------------------------------------融合召唤
function le.AddFusionProcGradationMixRep(c,sub,insf,fun1,minc,maxc,fun2,fun3,gf,...)
	if c:IsStatus(STATUS_COPYING_EFFECT) then return end
	local val={fun1,...}
	local fun={}
	local mat={}
	for i=1,#val do
		if type(val[i])=='function' then
			fun[i]=function(c,fc,sub,mg,sg) return val[i](c,fc,sub,mg,sg) and not c:IsHasEffect(6205579) end
		elseif type(val[i])=='table' then
			fun[i]=function(c,fc,sub,mg,sg)
					for _,fcode in ipairs(val[i]) do
						if type(fcode)=='function' then
							if fcode(c,fc,sub,mg,sg) and not c:IsHasEffect(6205579) then return true end
						else
							if c:IsFusionCode(fcode) or (sub and c:CheckFusionSubstitute(fc)) then return true end
						end
					end
					return false
			end
			for _,fcode in ipairs(val[i]) do
				if type(fcode)~='function' then mat[fcode]=true end
			end
		else
			fun[i]=function(c,fc,sub) return c:IsFusionCode(val[i]) or (sub and c:CheckFusionSubstitute(fc)) end
			mat[val[i]]=true
		end
	end
	local mt=getmetatable(c)
	if mt.material==nil then
		mt.material=mat
	end
	if mt.material_count==nil then
		mt.material_count={#fun+minc-1,#fun+maxc-1}
	end
	for index,_ in pairs(mat) do
		Auxiliary.AddCodeList(c,index)
	end
	return lf.S(c,1169,"FM","OE","E",nil,nil,le.FusionProcGradationCondition(insf,sub,fun2,fun3,gf,fun[1],minc,maxc,table.unpack(fun,2)),le.FusionProcGradationOperation(insf,sub,fun2,fun3,gf,fun[1],minc,maxc,table.unpack(fun,2)),c,nil,nil,nil) and c:EnableReviveLimit()
--为c 添加融合召唤手续1和2，在融合召唤c时可以选召唤方式，1为融合召唤，2为融合相关
--1：用额外参数里的卡和fun1各1张为融合素材,额外参数的类型 可以是 luaFunction 或者 卡密(int code),传入 code 相当于传入 luaFunction(code) return c:IsFusionCode(code) end
--2：用2个满足过滤条件 fun2 ，fun3 [的卡片组里满足过滤条件 gf ]的怪兽等级之合等于c时也可以作为融合素材
--sub表示能否使用融合代替素材，insf 为false表示必须用素材融合召唤。若这只怪兽融合召唤只能使用上述的卡进行，sub 和 insf 都要填 false
end
function le.FusionProcGradationCondition(insf,sub,f1,f2,gf,fun1,minc,maxc,...)
	local funs1={...}
	local funs2={f1,f2}
	return	function(e,g,gc,chkfnf)
				if g==nil then return insf and Auxiliary.MustMaterialCheck(nil,e:GetHandlerPlayer(),EFFECT_MUST_BE_FMATERIAL) end
				local c=e:GetHandler()
				local tp=c:GetControler()
				local notfusion=chkfnf&0x100>0
				local concat_fusion=chkfnf&0x200>0
				local sub=(sub or notfusion) and not concat_fusion
				local mg1=g:Filter(Auxiliary.FConditionFilterMix,c,c,sub,concat_fusion,fun1,table.unpack(funs1))
				local mg2=g:Filter(Auxiliary.FConditionFilterMix,c,c,sub,concat_fusion,table.unpack(funs2))
				if gc then
					if not mg:IsContains(gc) then return false end
					Duel.SetSelectedCard(Group.FromCards(gc))
				end
				local sg=Group.CreateGroup()
				return mg2:CheckSubGroup(le.FCheckGradationGoal,#funs2,#funs2,tp,c,sub,chkfnf,gf,table.unpack(funs2)) or mg1:IsExists(Auxiliary.FSelectMixRep,1,nil,tp,mg1,sg,c,sub,chkfnf,fun1,minc,maxc,table.unpack(funs1))
			end
end
function le.FusionProcGradationOperation(insf,sub,f1,f2,gf,fun1,minc,maxc,...)
	local funs1={...}
	local funs2={f1,f2}
	return	function(e,tp,eg,ep,ev,re,r,rp,gc,chkfnf)
				local c=e:GetHandler()
				local tp=c:GetControler()
				local notfusion=chkfnf&0x100>0
				local concat_fusion=chkfnf&0x200>0
				local sub=(sub or notfusion) and not concat_fusion
				local mg1=eg:Filter(Auxiliary.FConditionFilterMix,c,c,sub,concat_fusion,fun1,table.unpack(funs1))
				local sg=Group.CreateGroup()
				local mg2=eg:Filter(Auxiliary.FConditionFilterMix,c,c,sub,concat_fusion,table.unpack(funs2))
				if gc then Duel.SetSelectedCard(Group.FromCards(gc)) end
				local a=mg1:IsExists(Auxiliary.FSelectMixRep,1,nil,tp,mg1,sg,c,sub,chkfnf,fun1,minc,maxc,table.unpack(funs1))
				local b=mg2:CheckSubGroup(le.FCheckGradationGoal,#funs2,#funs2,tp,c,sub,chkfnf,gf,table.unpack(funs2))
				if not a and not b then return end
                local off=1
                local ops={}
                local opval={}
                if a then
                    ops[off]=1169
                    opval[off]=0
                    off=off+1
                end
                if b then
	                ops[off]=1128
	                opval[off]=1
	                off=off+1
	            end
	            local op=Duel.SelectOption(tp,table.unpack(ops))+1
	            local sel=opval[op]
	            if sel==0 then
	                while sg:GetCount()<maxc+#funs1 do
					local cg=mg1:Filter(Auxiliary.FSelectMixRep,sg,tp,mg1,sg,c,sub,chkfnf,fun1,minc,maxc,table.unpack(funs1))
					if cg:GetCount()==0 then break end
					local finish=Auxiliary.FCheckMixRepGoal(tp,sg,c,sub,chkfnf,fun1,minc,maxc,table.unpack(funs1))
					local cancel_group=sg:Clone()
					if gc then cancel_group:RemoveCard(gc) end
					Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_FMATERIAL)
					local tc=cg:SelectUnselect(cancel_group,tp,finish,false,minc+#funs1,maxc+#funs1)
					if not tc then break end
					if sg:IsContains(tc) then
						sg:RemoveCard(tc)
					else
						sg:AddCard(tc)
					end
				end
				Duel.SetFusionMaterial(sg)
	            elseif sel==1 then
				    Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_FMATERIAL)
				    local sg=mg2:SelectSubGroup(tp,le.FCheckGradationGoal,false,#funs2,#funs2,tp,c,sub,chkfnf,gf,table.unpack(funs2))
				    Duel.SetFusionMaterial(sg)
				end
			end
end
function lc.mnfilter(c,g,fc)
	return g:IsExists(lc.mnfilter2,1,c,c,fc)
end
function lc.mnfilter2(c,mc,fc)
	return c:GetLevel()+mc:GetLevel()==fc:GetLevel()
end
function le.FCheckGradationGoal(sg,tp,fc,sub,chkfnf,gf,...)
	local chkf=chkfnf&0xff
	local concat_fusion=chkfnf&0x200>0
	if not concat_fusion and sg:IsExists(Auxiliary.TuneMagicianCheckX,1,nil,sg,EFFECT_TUNE_MAGICIAN_F) then return false end
	if not Auxiliary.MustMaterialCheck(sg,tp,EFFECT_MUST_BE_FMATERIAL) then return false end
	local g=Group.CreateGroup()
	return sg:IsExists(lc.mnfilter,1,nil,sg,fc) and sg:IsExists(Auxiliary.FCheckMix,1,nil,sg,g,fc,sub,...) and (chkf==PLAYER_NONE or Duel.GetLocationCountFromEx(tp,tp,sg,fc)>0)
		and (not Auxiliary.FCheckAdditional or Auxiliary.FCheckAdditional(tp,sg,fc))
		and (not Auxiliary.FGoalCheckAdditional or Auxiliary.FGoalCheckAdditional(tp,sg,fc)) and gf(sg)
end
---
function le.EnableDarkSynchroAttribute(c)
	local owner, handler = lf.GetRegisterInfo(c)
	local mt = getmetatable(handler)
    if not mt.dark_synchro then
		mt.dark_synchro = true
	end
	--给 c 设置暗黑同调属性
end
function le.AddDarkSynchroProcedure(c,f1,f2,gf,min,max,loc1,loc2,op,...)
	local loc1=loc1 or 0
	local loc2=loc2 or 0
	local opp={...}
	if maxc==nil then maxc=99 end
	return lf.F(c,desc.typ,"SPOC","OE","E",nil,sptyp.syn,nil,le.Dark_Synchro_Con(f1,f2,gf,min,max,loc1,loc2),le.Dark_Synchro_Tg(f1,f2,gf,min,max,loc1,loc2),le.Dark_Synchro_Op(op,opp),c,nil,nil,nil) and c:EnableReviveLimit()
	--给 c 添加暗黑同调手续
	--用满足gf的自己loc1和对方loc2中包含f1为 1 只满足的过滤条件，并且必须为调整；f2为 minc [~ maxc]只满足的过滤条件
	--调整的等级-调整以外的等级之合=这张卡的等级，此过程中暗黑调整的等级为那张卡等级的相反数
	--op为作黑暗同调素材的处理，额外素材为op除g以外的参数
	--从第十个参数开始是额外参数
end
function le.Dark_Synchro_Con(f1,f2,gf,minc,maxc,self_location,opponent_location)
    return function(e,c,og,smat)
        if c==nil then return true end
		    local tp=c:GetControler()
		    local mg=Duel.GetMatchingGroup(lc.darkf,tp,self_location,opponent_location,nil)
		    local mg2=Duel.GetMatchingGroup(le.SExtraFilter,tp,lploc.all,0,nil,c,tp)
		    local mg3=Duel.GetMatchingGroup(le.HandSynFilter,tp,lp.ran["H"],0,nil,c)
		    if #mg2>0 then mg:Merge(mg2) end
		    if #mg3>0 then mg:Merge(mg3) end
		    local fg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_SMATERIAL)
		    if fg:IsExists(Auxiliary.MustMaterialCounterFilter,1,nil,mg) then return false end
		    Duel.SetSelectedCard(fg)
		    return mg:CheckSubGroup(le.Dark_SynchroGoal,minc,maxc,tp,c,f1,f2,smat,gf) and lc.IsDarkSynchro(c)
	end
end
function le.SExtraFilter(c,sc,tp)
	if c:IsOnField() and c:IsFacedown() then return false end
	if not c:IsCanBeSynchroMaterial(sc) then return false end
	local le={c:IsHasEffect(EFFECT_EXTRA_SYNCHRO_MATERIAL,tp)}
	for _,te in pairs(le) do
		local tf=te:GetValue()
		local related,valid=tf(te,sc,nil,c,tp)
		if related then return true end
	end
	return false
end
function le.HandSynFilter(c,sc)
	if not c:IsCanBeSynchroMaterial(sc) or not c:IsLocation(lp.ran["H"]) or not c:IsHasEffect(EFFECT_HAND_SYNCHRO) then return false end
	return c:IsHasEffect(EFFECT_HAND_SYNCHRO)
end
function le.Dark_Synchro_Tg(f1,f2,gf,minc,maxc,self_location,opponent_location)
	return	function(e,tp,eg,ep,ev,re,r,rp,chk,c,min,max,smat)
		    local minc=minc
		    local maxc=maxc
		    if min then
			    if min>minc then minc=min end
			    if max<maxc then maxc=max end
			    if minc>maxc then return false end
		    end
		    local name=lf.getname(c)
		    name=lf.RemoveMore(name)
		    local tp=c:GetControler()
		    local mg=Duel.GetMatchingGroup(lc.darkf,tp,self_location,opponent_location,nil)
		    local mg2=Duel.GetMatchingGroup(le.SExtraFilter,tp,lploc.all,0,nil,c,tp)
		    local mg3=Duel.GetMatchingGroup(le.HandSynFilter,tp,lp.ran["H"],0,nil,c)
		    if #mg2>0 then mg:Merge(mg2) end
		    if #mg3>0 then mg:Merge(mg3) end
		    local fg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_SMATERIAL)
		    if fg:IsExists(Auxiliary.MustMaterialCounterFilter,1,nil,mg) then return false end
		    Duel.SetSelectedCard(fg)
		    local cancel=Duel.IsSummonCancelable()
		    local tg=mg:SelectSubGroup(tp,le.Dark_SynchroGoal,cancel,minc,maxc,tp,c,f1,f2,smat,gf)
		    if tg then
				    tg:KeepAlive()
				    e:SetLabelObject(tg)
			    return true
		    else Debug.Message("无法或没有选择" ..  name .. "的暗黑同调素材") return false end
	end
end
function lc.Get_Dark_Level(c,sc)
    if c:IsSynchroType(lptyp.dtun) or c.dark_tuner then
	    local lv=0-c:GetSynchroLevel(sc)
		return lv
	else
		return c:GetSynchroLevel(sc)
	end
end
function le.Dark_SynchroGoal(g,tp,sc,f1,f2,smat,gf)
    if g:FilterCount(f2,nil)==0 then return false end
    local lv1=g:Filter(f1,nil):GetSum(lc.Get_Dark_Level,sc)
    local lv2=g:Filter(f2,nil):GetSum(lc.Get_Dark_Level,sc)
    local lv=-sc:GetLevel()
    return (lv1-lv2==lv) and Duel.GetLocationCountFromEx(tp,tp,g,sc)>0 and (not gf or gf(g,sc,tp)) and g:FilterCount(f1,nil)==1 and (not smat or g:IsContains(smat))
end
function le.Dark_Synchro_Op(mat_operation,operation_params)
	return	function(e,tp,eg,ep,ev,re,r,rp,c)
		    local tg=e:GetLabelObject()
		    c:SetMaterial(tg)
		    le.SExtraMaterialCount(tg,c,tp)
		    mat_operation(tg,table.unpack(operation_params))
		    tg:DeleteGroup()
		    lf.SC(c,nil,"SP","OE",nil,nil,le.darkop,c,nil,nil,nil)
    end
end
function le.darkop(e,tp,eg,ep,ev,re,r,rp)
        local c=e:GetHandler()
        local name = lf.getname(c)
        local name = lf.RemoveMore(name)
        if name then
	        Debug.Message("Tips:"  .. name .. "已使用暗黑召唤特殊召唤.")
	    end
	    le.RegisterFlagEffect(c, 1145141, "ST", nil, nil)
end
function le.SExtraMaterialCount(mg,sc,tp)
	for tc in aux.Next(mg) do
		local le={tc:IsHasEffect(EFFECT_EXTRA_SYNCHRO_MATERIAL,tp)}
		for _,te in pairs(le) do
			local sg=mg:Filter(aux.TRUE,tc)
			local f=te:GetValue()
			local related,valid=f(te,sc,sg,tc,tp)
			if related and valid then
				te:UseCountLimit(tp)
			end
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------------------------
function le.AddXyzProcedureFree(c,f,gf,og1,minc,maxc,ff,gff,mincc,maxcc,og2,rc)
	return lf.F(c,1165,"SPOC","OE","E",nil,sptyp.xyz,nil,le.XyzFreeCondition(f,gf,og1,minc,maxc,ff,gff,og2,mincc,maxcc),le.XyzFreeTarget(f,gf,og1,minc,maxc,ff,gff,og2,mincc,maxcc),le.XyzFreeOperation(f,gf,og1,minc,maxc,ff,gff,og2,mincc,maxcc),rc,nil,nil,nil) and c:EnableReviveLimit()
	--为rc添加超量召唤手续,
    --用满足条件 f 的卡片组里，在满足 og1 满足 gf 的 minc[-maxc] 张卡和满足条件 ff 的卡片组里，在满足 og2 满足 gff 的mincc[-maxcc] 张卡进行叠放，f,ff 为必要条件，gf 为额外条件， og1, og2 指位置
end
function le.XyzFreeFilter(c,xyzc,f)
	return c:IsCanBeXyzMaterial(xyzc) and (not f or f(c,xyzc))
end
function le.XyzFreeCondition(f,gf,og,minct,maxct,ff,gff,ogg,mincct,maxcct)
	return	function(e,c,min,max)
				if c==nil then return true end
				local tp=c:GetControler()
				local minc=minct
				local maxc=maxct
				if min then
					minc=math.max(minc,min)
					maxc=math.min(maxc,max)
				end
				if maxc<minc then return false end
				local mg=Duel.GetMatchingGroup(nil,tp,og,0,nil)
				mg=mg:Filter(le.XyzFreeFilter,nil,c,f)
				local mgg=Duel.GetMatchingGroupCount(nil,tp,ogg,0,nil)
				local sg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_XMATERIAL)
				if sg:IsExists(Auxiliary.MustMaterialCounterFilter,1,nil,mg) then return false end
				Duel.SetSelectedCard(sg)
				Auxiliary.GCheckAdditional=Auxiliary.TuneMagicianCheckAdditionalX(EFFECT_TUNE_MAGICIAN_X)
				local res=mg:CheckSubGroup(Auxiliary.XyzLevelFreeGoal,minc,maxc,tp,c,gf) and mgg>=mincct
				Auxiliary.GCheckAdditional=nil
				return res
			end
end
function le.XyzFreeTarget(f,gf,og,minct,maxct,ff,gff,ogg,mincct,maxcct,ogg)
	return	function(e,tp,eg,ep,ev,re,r,rp,chk,c,min,max)
				if og and not min then
					return true
				end
				local cc=e:GetHandler()
				local name=lf.getname(cc)
				local minc=minct
				local maxc=maxct
				if min then
					if min>minc then minc=min end
					if max<maxc then maxc=max end
				end
				local mg=nil
				og=Duel.GetMatchingGroup(nil,tp,og,0,nil)
				mg=og:Filter(le.XyzFreeFilter,nil,c,f)
				local mgg=Duel.GetMatchingGroup(nil,tp,ogg,0,nil)
				local sg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_XMATERIAL)
				Duel.SetSelectedCard(sg)
				Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_XMATERIAL)
				local cancel=Duel.IsSummonCancelable()
				Auxiliary.GCheckAdditional=Auxiliary.TuneMagicianCheckAdditionalX(EFFECT_TUNE_MAGICIAN_X)
				local g1=mg:SelectSubGroup(tp,Auxiliary.XyzLevelFreeGoal,cancel,minc,maxc,tp,c,gf)
				local g2=mgg:SelectSubGroup(tp,Auxiliary.XyzLevelFreeGoal,cancel,mincct,maxcct,tp,c,gff)
				local g=g1:Merge(g2)
				Auxiliary.GCheckAdditional=nil
				if g and g:GetCount()>0 then
					g:KeepAlive()
					e:SetLabelObject(g)
					return true
				else Debug.Message("无法或没有选择" .. name .. "'的超量素材") return false end
			end
end
function le.XyzFreeOperation(f,gf,og,minct,maxct,ff,gff,ogg,mincct,maxcct)
	return	function(e,tp,eg,ep,ev,re,r,rp,c,min,max)
				if not min then
					local sg=Group.CreateGroup()
					local og=Duel.GetMatchingGroup(nil,tp,og,0,nil)
					og=og:SelectSubGroup(tp,Auxiliary.XyzLevelFreeGoal,cancel,minc,maxc,tp,c,gf)
					local tc=og:GetFirst()
					local sg=Group.CreateGroup()
					while tc do
						local sg1=tc:GetOverlayGroup()
						sg:Merge(sg1)
						tc=og:GetNext()
					end
					local mgg=Duel.GetMatchingGroup(nil,tp,ogg,0,nil)
					mgg=mgg:SelectSubGroup(tp,Auxiliary.XyzLevelFreeGoal,cancel,mincct,maxcct,tp,c,gff) 
					local tcc=mgg:GetFirst()
					local sgg=Group.CreateGroup()
					while tc do
						local sgg1=tcc:GetOverlayGroup()
						sgg:Merge(sgg1)
						tcc=ogg:GetNext()
					end
					local g=sg:Merge(sgg)
					Duel.SendtoGrave(sg,REASON_RULE)
					og:Merge(mgg)
					c:SetMaterial(og)
					Duel.Overlay(c,og)
				else
					local mg=e:GetLabelObject()
					if e:GetLabel()==1 then
						local mg2=mg:GetFirst():GetOverlayGroup()
						if mg2:GetCount()~=0 then
							Duel.Overlay(c,mg2)
						end
					else
						local sg=Group.CreateGroup()
						local tc=mg:GetFirst()
						while tc do
							local sg1=tc:GetOverlayGroup()
							sg:Merge(sg1)
							tc=mg:GetNext()
						end
						Duel.SendtoGrave(sg,REASON_RULE)
					end
					mg:Merge(mgg)
					c:SetMaterial(mg)
					lf.D("HS",mg)
					Duel.Overlay(c,mg)
					mg:DeleteGroup()
				end
			end
end
----------
function le.EnableAddSetCard(c,setcode,location,condition)
	local loc=c:GetOriginalType()&lptyp.m~=0 and lp.ran["M"] or lp.ran["S"]
	loc=location or loc
	if condition==nil then condition=Auxiliary.TRUE end
	local e1=Effect.CreateEffect(c)
	e1:SetLPType("S")
	e1:SetLPProperty("SR")
	e1:SetCode(EFFECT_ADD_SETCODE)
	e1:SetRange(loc)
	e1:SetCondition(condition)
	e1:SetValue(setcode)
	c:RegisterEffect(e1)
	return e1 --为 c 在 location 添加字段 setcode，condition为满足的场合
end
-------------------------

---------------------------------------------------------------------------------------------------------------------------------------------
function le.AddSpecialLinkProcedure(c,f,min,max,gf,alterf,con,tg,op)
	local e1=Effect.CreateEffect(c)
	e1:SetDescription(1166)
	e1:SetLPType("F")
	e1:SetLPCode("SPOC")
	e1:SetLPProperty("OE")
	e1:SetRange(lp.ran["E"])
	if max==nil then max=c:GetLink() end
	if alterf then
	    e1:SetCondition(con)
	    e1:SetTarget(tg)
	    e1:SetOperation(op)
	else
	    e1:SetCondition(le.LinkCondition(f,min,max,gf))
	    e1:SetTarget(le.LinkTarget(f,min,max,gf))
	    e1:SetOperation(Auxiliary.LinkOperation(f,min,max,gf))
	end
    e1:SetValue(sptyp.link)
	c:RegisterEffect(e1)
	return e1 and c:EnableReviveLimit()
--为c添加连接召唤手续
--用 minc-maxc 个满足过滤条件 f [的卡片组里满足过滤条件 gf ]的怪兽作为连接素材（可以使用里侧表示的怪兽作为连接素材）
--或者用其他的方式连接召唤
--当 alterf 不等于 nil 时，con 为召唤时需要满足的条件，tg 为召唤时需要的对象，op 为召唤时需要的操作
end
function le.LinkCondition(f,minc,maxc,gf)
	return	function(e,c,og,lmat,min,max)
				if c==nil then return true end
				if c:IsType(lptyp.pen) and c:IsFaceup() then return false end
				local minc=minc
				local maxc=maxc
				if min then
					if min>minc then minc=min end
					if max<maxc then maxc=max end
					if minc>maxc then return false end
				end
				local tp=c:GetControler()
				local mg=nil
				if og then
					mg=og:Filter(lc.LConditionFilter,nil,f,c)
				else
					mg=lg.GetLinkMaterials(tp,f,c)
				end
				if lmat~=nil then
					if not lc.LConditionFilter(lmat,f,c) then return false end
					mg:AddCard(lmat)
				end
				local fg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_LMATERIAL)
				if fg:IsExists(Auxiliary.MustMaterialCounterFilter,1,nil,mg) then return false end
				Duel.SetSelectedCard(fg)
				return mg:CheckSubGroup(Auxiliary.LCheckGoal,minc,maxc,tp,c,gf,lmat)
			end
end
function le.LinkTarget(f,minc,maxc,gf)
	return	function(e,tp,eg,ep,ev,re,r,rp,chk,c,og,lmat,min,max)
				local minc=minc
				local maxc=maxc
				local cc=e:GetHandler()
				local name = lf.getname(cc)
				if min then
					if min>minc then minc=min end
					if max<maxc then maxc=max end
					if minc>maxc then return false end
				end
				local mg=nil
				if og then
					mg=og:Filter(lc.LConditionFilter,nil,f,c)
				else
					mg=lg.GetLinkMaterials(tp,f,c)
				end
				if lmat~=nil then
					if not lc.LConditionFilter(lmat,f,c) then return false end
					mg:AddCard(lmat)
				end
				local fg=Duel.GetMustMaterial(tp,EFFECT_MUST_BE_LMATERIAL)
				Duel.SetSelectedCard(fg)
				Duel.Hint(HINT_SELECTMSG,tp,HINTMSG_LMATERIAL)
				local cancel=Duel.IsSummonCancelable()
				local sg=mg:SelectSubGroup(tp,Auxiliary.LCheckGoal,cancel,minc,maxc,tp,c,gf,lmat)
				if sg then
					sg:KeepAlive()
					e:SetLabelObject(sg)
					return true
				else Debug.Message("无法或没有选择" .. name .. "'的连接素材") return false end
			end
end
---------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------
function le.textcon(e,tp,eg,ep,ev,re,r,rp)
	return le.IsFormalSpType(e:GetHandler())
end
function le.textop(text)
	return function(e,tp,eg,ep,ev,re,r,rp)
	    local name = lf.getname(c)
			return Debug.Message("Tips:"  .. name .. "已特殊召唤.") and le.CheckString(text)
		--if not c:IsRelateToEffect(e) then return end
		--if Duel.SpecialSummon(c,0,tp,tp,false,false,POS_FACEUP_DEFENSE)~=0 then func(e,tp) end
	end
end
function le.IsFormalSpType(card)
	local summonType = card:GetSummonType()
	local cardType = card:GetType()
	if summonType == sptyp.n and bit.band(cardType, lptyp.n) ~= 0 then
		return true
	elseif summonType == sptyp.rit and bit.band(cardType, lptyp.rit) ~= 0 then
		return true
	elseif summonType == sptyp.fus and bit.band(cardType, lptyp.fus) ~= 0 then
		return true
	elseif summonType == sptyp.syn and bit.band(cardType, lptyp.syn) ~= 0 then
		return true
	elseif summonType == sptyp.xyz and bit.band(cardType, lptyp.xyz) ~= 0 then
		return true
	elseif summonType == sptyp.link and bit.band(cardType, lptyp.link) ~= 0 then
		return true
	else
		return false
	end
	--检测是否已是正规召唤
end
function le.CheckString(inputString, separator)
    local result = {}
    local i = 1
    for str in string.gmatch(inputString, "([^" .. separator .. "]+)") do
        result[i] = str
        i = i + 1
    end
    return result --检测是否为正规特招出场
end

function le.PrintLines(inputString)
    local lines = le.CheckString(inputString, "||")
    for i, line in ipairs(lines) do
        Debug.Message(line) --输出text
    end
end
function Effect.gc(e)
    return e:GetHandler()
end
---------------------------------------------------------------------------------------------------------------------------------------------
function le.GetRcSystemPoint(tp,cp,loc,seq)
    local point={}
    if cp==tp then cp=-1 else cp=1 end
    if loc==lp.ran["M"] then
        if seq<5 then
            point={(2-seq)*cp,1*cp}
        else
            point={((-2)*seq+11)*cp,0}
        end
    else
        if seq~=5 then
            point={(2-seq)*cp,2*cp}
        else
            point={3*cp,1*cp}
        end
    end
    return point --手动返回格子
end
-------------------------------------------------------------------------------------------"支持函数"
function lf.DeleteNil(list)
	local setlist = {}
	for _,set in ipairs(list) do
		if not (type(set) == "table" and #set == 1) then
			table.insert(setlist,set)
		end
	end
	return setlist
end
function lf.Loc(locs,chk)
	if string.len(locs) == 0 then 
		Debug.Message("lp.Loc() wrong value")
		return 0 
	end
	local loctable = {0,0}
	local locmark = 1
	for i = 1,string.len(locs) do
		local loc = string.sub(locs, i, i)
		if loc == "+" then
			locmark = locmark + 1
		else
			loctable[locmark] = loctable[locmark] + lp.ran[string.upper(loc)]
		end
	end
	if chk then loctable = {loctable[1]} end
	return table.unpack(loctable)
end
function lf.Not_All_nil(...)
	local v = {...}
	v=type(v) =="table" and type(v[1]) =="table" and v[1] or v
	for _,l in pairs(v) do
		return l
	end
	return false
end
function lf.GetCardTable(c)
--返回 Card Table
	local C = {}
	if aux.GetValueType(c) == "Effect" then
		C[1] = c:GetHandler()
	elseif aux.GetValueType(c) == "Card" then
		C[1] = c
	elseif aux.GetValueType(c) == "Group" then
		for i in aux.Next(c) do
			C[#C+1] = i
		end
	end
	return C 
end
function lf.des(e,v)
--返回 des
	v = #v==1 and v[1] or v
	if type(v) == "table" then
		v = aux.Stringid(table.unpack(v))
	elseif type(v) == "string" then
		v = lp.des[v]
	elseif type(v) == "number" then
		v = v<17 and aux.Stringid(e:GetOwner():GetOriginalCode(),v) or v
	end
	return e,v
end
function lf.msg(v)
    return type(v) == "string" and lp.msg[v] or v
end
function lf.desc(c,v)
--返回 des
	v = #v==1 and v[1] or v
	if type(v) == "table" then
		v = aux.Stringid(table.unpack(v))
	elseif type(v) == "string" then
		v = lp.des[v]
	elseif type(v) == "number" then
		v = v<17 and aux.Stringid(c:GetOriginalCode(),v) or v
	end
	return v
end
function lf.cat(v)
--返回 category
    local V=0
	if type(v) == "string" then V = lp.cat[v] or v
	elseif type(v) == "table" then 
	    for i = 1, #v do
            local A=v[i]
            if i==1 then
                V=lp.cat[A]
            elseif i>1 then
                V=V + lp.cat[A]
            end
        end
    end
	return V
end
function lf.cod(v)
--返回 code
    local V=0
	if type(v) == "string" then V = lp.cod[v] or v
	elseif type(v) == "table" then 
	    for i = 1, #v do
            local A=v[i]
            if i==1 then
                V=lp.cod[A]
            elseif i>1 then
                V=V + lp.cod[A]
            end
        end
    end
	return V
end
function lf.pro(v)
--返回 property
	local V=0
	if type(v) == "string" then V = lp.pro[v] or v
	elseif type(v) == "table" then 
	    for i = 1, #v do
            local A=v[i]
            if i==1 then
                V=lp.pro[A]
            elseif i>1 then
                V=V + lp.pro[A]
            end
        end
    end
	return V
end
function lf.typ(v)
--返回 type
    local V=0
	if type(v) == "string" then V = type(v) == "string" and lp.typ[v] or v
	elseif type(v) == "table" then 
	    for i = 1, #v do
            local A=v[i]
            if i==1 then
                V=lp.typ[A]
            elseif i>1 then
                V=V + lp.typ[A]
            end
        end
    end
	return V
end
function lf.ctl(e,v)
--返回 count limit
	v = type(v) == "table" and v or { v }
	local V = {nil,nil,nil}
	for i = 1, #v do
		V[3] = type(v[i]) == "string" and v[i] or V[3]
		V[2] = type(v[i]) == "number" and v[i]>99 and v[i] or V[2]
		V[1] = type(v[i]) == "number" and v[i]<99 and v[i] or V[1]
	end
	if V[3] and not V[2] and not V[1] then V[2] = e:GetOwner():GetOriginalCode() end
	if V[3] then V[2] = V[2] + lp.ctl[V[3] ] end
	V[1] = V[1] or 1
	return e,table.unpack(V)
end
function lf.res(v)
	return type(v) == "string" and lp.res[v] or v
end
function lf.tran(v)
--返回 target range
	v = type(v[1]) == "table" and v[1] or v
	return table.unpack(v)
end
function lf.Glo(c,tp,des,cat,typ,cod,pro,ran,tran,val,ctl,con,cos,tg,op,res,lab,obj)
	return le.Global(c,tp,{"DES",des},{"CAT",cat},{"TYP",typ},{"COD",cod},{"PRO",pro},{"RAN",ran},{"TRAN",tran},{"VAL",val},
		{"CTL",ctl},{"CON",con},{"COS",cos},{"TG",tg},{"OP",op},{"RES",res},{"LAB",lab},{"LABOBJ",obj}) --全局效果
end
function lf.Clo(e,des,cat,typ,cod,pro,ran,tran,val,ctl,con,cos,tg,op,rc,res,lab,obj)
	return le.Clone(e,rc,{"DES",des},{"CAT",cat},{"TYP",typ},{"COD",cod},{"PRO",pro},{"RAN",ran},{"TRAN",tran},{"VAL",val},
		{"CTL",ctl},{"CON",con},{"COS",cos},{"TG",tg},{"OP",op},{"RES",res},{"LAB",lab},{"LABOBJ",obj}) --复制效果
end
function lf.Act(c,des,cat,typ,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return le.Creat(c,rc,{"DES",des},{"CAT",cat},{"TYP",typ},{"COD",cod},{"PRO",pro},{"RAN",ran},
		{"CTL",ctl},{"CON",con},{"COS",cos},{"TG",tg},{"OP",op},{"RES",res},{"LAB",lab},{"LABOBJ",obj}) --"要发动的效果"
end  
function lf.B_A(c,des,cat,cod,pro,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,"ACT",cod or "FC",pro,nil,ctl,con,cos,tg,op,rc,res,lab,obj) --"魔陷起动效果"
end  
function lf.A(c,cod,rc)
	return lf.B_A(c,nil,nil,cod,nil,nil,nil,nil,nil,nil,rc) --"魔陷起动效果"
end
function lf.I(c,des,cat,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,"I",nil,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"起动效果"
end
function lf.QO(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,"QO",cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"诱发即时选发效果"
end
function lf.QF(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,"QF",cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"诱发既时必发效果"
end
function lf.FTO(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,{"F","TO"},cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"场上变化诱发选发效果"
end
function lf.FTF(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,{"F","TF"},cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"场上变化诱发必发效果"
end
function lf.STO(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,{"S","TO"},cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"自己变化诱发选发效果"
end 
function lf.STF(c,des,cat,cod,pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj)
	return lf.Act(c,des,cat,{"S","TF"},cod or "FC",pro,ran,ctl,con,cos,tg,op,rc,res,lab,obj) --"自己变化诱发必发效果"
end   
function lf.NoAct(c,des,typ,cod,pro,ran,tran,val,ctl,con,tg,op,rc,res,lab,obj)
	return le.Creat(c,rc,{"DES",des},{"TYP",typ},{"COD",cod},{"PRO",pro},{"RAN",ran},{"TRAN",tran},{"VAL",val},
		{"CTL",ctl},{"CON",con},{"TG",tg},{"OP",op},{"RES",res},{"LAB",lab},{"LABOBJ",obj}) --"不用发动的效果"
end  
function lf.S(c,des,cod,pro,ran,val,ctl,con,op,rc,res,lab,obj)
	return lf.NoAct(c,des,"S",cod,pro,ran,nil,val,ctl,con,nil,op,rc,res,lab,obj) --"自己变化永续效果"
end
function lf.SC(c,des,cod,pro,ctl,con,op,rc,res,lab,obj)
	return lf.NoAct(c,des,{"S","C"},cod,pro,nil,nil,nil,ctl,con,nil,op,rc,res,lab,obj) --"自己变化事件效果"
end
function lf.F(c,des,cod,pro,ran,tran,val,ctl,con,tg,op,rc,res,lab,obj)
	return lf.NoAct(c,des,"F",cod,pro,ran,tran,val,ctl,con,tg,op,rc,res,lab,obj) --"场上变化永续效果"
end
function lf.FC(c,des,cod,pro,ran,ctl,con,op,rc,res,lab,obj)
	return lf.NoAct(c,des,{"F","C"},cod,pro,ran,nil,ctl,nil,con,nil,op,rc,res,lab,obj) --"场上变化事件效果"
end
function lf.FG(c,pro,ran,tran,con,tg,rc,res,lab,obj)
	return lf.NoAct(c,nil,{"F","G"},nil,pro,ran,nil,tran,nil,con,tg,nil,rc,res,lab,obj) --"使其他卡获得效果"
end
function lf.TEXT(c,text)
	return lf.SC(c,nil,"SP","OE",nil,le.textcon,le.textop(text),c) --"这张卡正规召唤成功的场合，Debug弹出 text 文本内容"
end
function lf.SPCON(c,ran,val,con)
    return lf.S(c,nil,"ESC",nil,ran,nil,val,nil,con,nil,nil,c)
end
function lf.getname(c)
    local mt=lf.getmetatable(c)
    if Auxiliary.GetValueType(c)=="Card" then c=c:GetOriginalCode() end
    if lpname[c] then
        return lpname[c]
    elseif mt.name then
        return mt.name
    else
        return "c","nil"
    end
end
function lf.GetName(c)
    local mt=lf.getmetatable(c)
    if Auxiliary.GetValueType(c)=="Card" then c=c:GetCode() end
    if lpname[c] then
        return lpname[c]
    elseif mt.name then
        return mt.name
    else
        return "c","nil"
    end
end
lp.loaded_metatable_list=lp.loaded_metatable_list or {}
function lf.getmetatable(c)
    local code=c:GetOriginalCode()
	local m1=_G["c"..code]
	if m1 then return m1 end
	local m2=lp.loaded_metatable_list[code]
	if m2 then return m2 end
	_G["c"..code]={}
	if pcall(function() dofile("expansions/script/c"..code..".lua") end) or pcall(function() dofile("script/c"..code..".lua") end) then
		local mt=_G["c"..code]
		_G["c"..code]=nil
		if mt then
			lp.loaded_metatable_list[code]=mt
			return mt
		end
	else
		_G["c"..code]=nil
	end
end
function lf.GetRegisterInfo(reg_obj)
	local reg_arr = type(reg_obj) == "table" and reg_obj or { reg_obj }
	return reg_arr[1] , reg_arr[2] or reg_arr[1], reg_arr[3] or false
end
function lf.IsExistingMatchingCard(f,py,s,o,ct,ex,...)
    return Duel.IsExistingMatchingCard(f,py,lp.ran[s],lp.ran[o],ct,ex,...)
end
function lf.IsExistingTarget(f,py,s,o,ct,ex,...)
    return Duel.IsExistingTarget(f,py,lp.ran[s],lp.ran[o],ct,ex,...)
end
function lf.SetOperationInfo(cha,cat,g,ct,py,loc)
    return Duel.SetOperationInfo(cha,lp.cat[cat],g,ct,py,lp.ran[loc])
end
function lf.GetMatchingGroup(f,py,s,o,ex,...)
    return Duel.GetMatchingGroup(f,py,lp.ran[s],lp.ran[o],ex,...)
end
function lf.SelectMatchingCard(spy,f,py,s,o,min,max,ex,...)
    return Duel.SelectMatchingCard(spy,f,py,lp.ran[s],lp.ran[o],min,max,ex,...)
end
function lf.GetFieldGroup(py,s,o)
    return Duel.GetFieldGroup(py,lp.ran[s],lp.ran[o])
end
function lf.GetFieldGroupCount(py,s,o)
    return Duel.GetFieldGroupCount(py,lp.ran[s],lp.ran[o])
end
function lf.SelectTarget(spy,f,py,s,o,min,max,ex,...)
    return Duel.SelectTarget(spy,f,py,lp.ran[s],lp.ran[o],min,max,ex,...)
end
function lf.RemoveMore(msg)
    local a,b = string.find(msg,"%s",1)
    local more = string.sub(msg,1,b)
    local nm = string.gsub(msg,more,"")
    return nm
end
function lf.hint(typ,py,desc)
    typ= lf.msg(typ)
    if typ == lp.msg["S"] then desc = lf.msg(desc) end
    return Duel.Hint(typ,py,desc)
end
lf.Hint=lf.hint
function lf.RegisterFlagEffect(py,cod,res,pro,ct1,ct2,desc)
    if not py then py=0 end
    if res then res=lf.res(res) end
    if pro then pro=lf.pro(pro) end
    if not ct1 then ct1 =1 end
    if not ct2 then ct2 = 0 end
    return Duel.RegisterFlagEffect(py,cod,res,pro,ct1,ct2,desc) --为py注册一个标识用效果
end
function lf.D(msg,...)
    local list = {...}
    local V=nil
    return lp.due(msg,...)
end
function lf.E(e,eff,...)
    return lp.E(e,eff,...)
end
function lf.M(text)
    return Debug.Message(text)
end
lp.eff = lp.eff or { }
function lf.RegEffect(e,tp)
    local t=lp.eff
    table.insert(t,#t+1,e)
    return Duel.RegisterEffect(e,tp)
end
function lf.GetRegEff(e)
    local t=t or { }
    local c=lf.E(e,"GH")
    for i=1,#lp.eff do
        if lf.E(lp.eff[i],"GH")==c then
            table.insert(t,#t+1,lp.eff[i])
        end
    end
    return t
end
function lf.CheckCardAndPlayerEffect(e,c,tp)
    if e:GetOwnerPlayer()==tp and lf.E(e,"GW")==c then return true end
    return false
end
function lf.EffectSetToTable(e,c,tp)
    local t=lp.eff
    if lf.CheckCardAndPlayerEffect(e,c,tp) then return table.insert(t,#t+1,e) end
    return false
end
------------------------
function ls.ifadd(ct,a,b,c)
    if not type(a)=="string" or not type(b)=="string" or not type(c)=="string" then return false end
    local text=nil
    if ct==0 then
        text=a..b
    else
        text=a..c
    end
    ct=ct+1
    return text,ct
end
function ls.att(att)
    local text=""
    local a=0
    if att&lpatt.da==lpatt.da then text,a=ls.ifadd(a,text,"暗","·暗") end
    if att&lpatt.wa==lpatt.wa then text,a=ls.ifadd(a,text,"水","·水") end
    if att&lpatt.ea==lpatt.ea then text,a=ls.ifadd(a,text,"地","·地") end
    if att&lpatt.fr==lpatt.fr then text,a=ls.ifadd(a,text,"火","·火") end
    if att&lpatt.wd==lpatt.wd then text,a=ls.ifadd(a,text,"风","·风") end
    if att&lpatt.lg==lpatt.lg then text,a=ls.ifadd(a,text,"光","·光") end
    if att&0x40==0x40 then text,a=ls.ifadd(a,text,"神","·神") end
    return text
end 
function ls.att1(att)
    local text=""
    local a=0
    if att&lpatt.da==lpatt.da then text,a=ls.ifadd(a,text,"暗","或暗") end
    if att&lpatt.wa==lpatt.wa then text,a=ls.ifadd(a,text,"水","或水") end
    if att&lpatt.ea==lpatt.ea then text,a=ls.ifadd(a,text,"地","或地") end
    if att&lpatt.fr==lpatt.fr then text,a=ls.ifadd(a,text,"火","或火") end
    if att&lpatt.wd==lpatt.wd then text,a=ls.ifadd(a,text,"风","或风") end
    if att&lpatt.lg==lpatt.lg then text,a=ls.ifadd(a,text,"光","或光") end
    if att&0x40==0x40 then text,a=ls.ifadd(a,text,"神","或神") end
    return text
end
function ls.Type_Mst(typ)
    local text=""
    local a=0
    local type=0
    if typ&lptyp.m==lptyp.m then 
        text,a=ls.ifadd(a,text,"怪兽","·怪兽") 
        if type==0 then type=lptyp.m
        else type=type+lptyp.m end
    end
    if typ&lptyp.s==lptyp.s then 
        text,a=ls.ifadd(a,text,"魔法","·魔法")
        if type==0 then type=lptyp.s
        else type=type+lptyp.s end
    end
    if typ&lptyp.s==lptyp.s then 
        text,a=ls.ifadd(a,text,"陷阱","·陷阱")
        if type==0 then type=lptyp.t
        else type=type+lptyp.t end
    end
    return text,type
end