﻿namespace MDPro3.YGOSharp.OCGWrapper.Enums
{
    public enum CardLocation
    {
        Unknown = 0,
        Deck = 0x01,
        Hand = 0x02,
        MonsterZone = 0x04,
        SpellZone = 0x08,
        Grave = 0x10,
        Removed = 0x20,
        Extra = 0x40,
        Overlay = 0x80,
        Onfield = 0x0C,
        FieldZone = 0x100,
        PendulumZone = 0x200,
        Search = 0x800
    }
    public enum CardPosition
    {
        FaceUpAttack = 0x1,
        FaceDownAttack = 0x2,
        FaceUpDefence = 0x4,
        FaceDownDefence = 0x8,
        FaceUp = 0x5,
        FaceDown = 0xA,
        Attack = 0x3,
        Defence = 0xC
    }
    public enum CardType
    {
        Monster = 0x1,
        Spell = 0x2,
        Trap = 0x4,
        Normal = 0x10,
        Effect = 0x20,
        Fusion = 0x40,
        Ritual = 0x80,
        TrapMonster = 0x100,
        Spirit = 0x200,
        Union = 0x400,
        Dual = 0x800,
        Tuner = 0x1000,
        Synchro = 0x2000,
        Token = 0x4000,
        QuickPlay = 0x10000,
        Continuous = 0x20000,
        Equip = 0x40000,
        Field = 0x80000,
        Counter = 0x100000,
        Flip = 0x200000,
        Toon = 0x400000,
        Xyz = 0x800000,
        Pendulum = 0x1000000,
        SpSummon = 0x2000000,
        Link = 0x4000000
    }

    public enum CardAttribute
    {
        Earth = 0x01,
        Water = 0x02,
        Fire = 0x04,
        Wind = 0x08,
        Light = 0x10,
        Dark = 0x20,
        Divine = 0x40,
        All = 0x7f,
        Count = 7
    }
    public enum CardRace
    {
        Warrior = 0x1,
        SpellCaster = 0x2,
        Fairy = 0x4,
        Fiend = 0x8,
        Zombie = 0x10,
        Machine = 0x20,
        Aqua = 0x40,
        Pyro = 0x80,
        Rock = 0x100,
        WindBeast = 0x200,
        Plant = 0x400,
        Insect = 0x800,
        Thunder = 0x1000,
        Dragon = 0x2000,
        Beast = 0x4000,
        BeastWarrior = 0x8000,
        Dinosaur = 0x10000,
        Fish = 0x20000,
        SeaSerpent = 0x40000,
        Reptile = 0x80000,
        Psycho = 0x100000,
        DivineBeast = 0x200000,
        CreatorGod = 0x400000,
        Wyrm = 0x800000,
        Cyberse = 0x1000000,
        Illustion = 0x2000000,
        All = 0x3ffffff,
        Count = 26
    }

    public enum CardReason
    {
        DESTROY = 0x1,
        RELEASE = 0x2,
        TEMPORARY = 0x4,
        MATERIAL = 0x8,
        SUMMON = 0x10,
        BATTLE = 0x20,
        EFFECT = 0x40,
        COST = 0x80,
        ADJUST = 0x100,
        LOST_TARGET = 0x200,
        RULE = 0x400,
        SPSUMMON = 0x800,
        DISSUMMON = 0x1000,
        FLIP = 0x2000,
        DISCARD = 0x4000,
        RDAMAGE = 0x8000,
        RRECOVER = 0x10000,
        RETURN = 0x20000,
        Fusion = 0x40000,
        Synchro = 0x80000,
        Ritual = 0x100000,
        Xyz = 0x200000,
        REPLACE = 0x1000000,
        DRAW = 0x2000000,
        REDIRECT = 0x4000000,
        REVEAL = 0x8000000,
        Link = 0x10000000,
        LOST_OVERLAY = 0x20000000
    }
    public enum CardStatus
    {
        Disabled = 0x1,
        ToEnable = 0x2,
        ToDisable = 0x4,
        Proc_Complete = 0x8,
        Set_Turn = 0x10,
        No_Level = 0x20,
        BattleResult = 0x40,
        SpSummonStep = 0x80,
        FormChanged = 0x100,
        Summing = 0x200,
        EffectEnabled = 0x400,
        SummonTurn = 0x800,
        DestroyConfirmed = 0x1000,
        LeaveConfirmed = 0x2000,
        BattleDestroyed = 0x4000,
        CopyingEffect = 0x8000,
        Chaining = 0x10000,
        SummonDisabled = 0x20000,
        ActivateDisabled = 0x40000,
        EffectReplaced = 0x80000,
        FutureFusion = 0x100000,
        AttackCanceled = 0x200000,
        Initializing = 0x400000,
        ToHandWithoutConfirm = 0x800000,
        JustPos = 0x1000000,
        ContinuousPos = 0x2000000,
        Forbidden = 0x4000000,
        ActFromHand = 0x8000000,
        OppoBattle = 0x10000000,
        FlipSummonTurn = 0x20000000,
        SpsummonTurn = 0x40000000
    }

    public enum Query
    {
        Code = 0x01,
        Position = 0x02,
        Alias = 0x04,
        Type = 0x08,
        Level = 0x10,
        Rank = 0x20,
        Attribute = 0x40,
        Race = 0x80,
        Attack = 0x100,
        Defence = 0x200,
        BaseAttack = 0x400,
        BaseDefence = 0x800,
        Reason = 0x1000,
        ReasonCard = 0x2000,
        EquipCard = 0x4000,
        TargetCard = 0x8000,
        OverlayCard = 0x10000,
        Counters = 0x20000,
        Owner = 0x40000,
        Status = 0x80000,
        LScale = 0x200000,
        RScale = 0x400000,
        Link = 0x800000
    }

    public enum CardLinkMarker
    {
        BottomLeft = 0x01,
        Bottom = 0x02,
        BottomRight = 0x04,
        Left = 0x08,
        Right = 0x20,
        TopLeft = 0x40,
        Top = 0x80,
        TopRight = 0x100
    }
    public enum GameMessage
    {
        Retry = 1,
        Hint = 2,
        Waiting = 3,
        Start = 4,
        Win = 5,
        UpdateData = 6,
        UpdateCard = 7,
        RequestDeck = 8,
        SelectBattleCmd = 10,
        SelectIdleCmd = 11,
        SelectEffectYn = 12,
        SelectYesNo = 13,
        SelectOption = 14,
        SelectCard = 15,
        SelectChain = 16,
        SelectPlace = 18,
        SelectPosition = 19,
        SelectTribute = 20,
        SortChain = 21,
        SelectCounter = 22,
        SelectSum = 23,
        SelectDisfield = 24,
        SortCard = 25,
        SelectUnselect = 26,
        ConfirmDecktop = 30,
        ConfirmCards = 31,
        ShuffleDeck = 32,
        ShuffleHand = 33,
        RefreshDeck = 34,
        SwapGraveDeck = 35,
        ShuffleSetCard = 36,
        ReverseDeck = 37,
        DeckTop = 38,
        ShuffleExtra = 39,
        NewTurn = 40,
        NewPhase = 41,
        ConfirmExtratop = 42,
        Move = 50,
        PosChange = 53,
        Set = 54,
        Swap = 55,
        FieldDisabled = 56,
        Summoning = 60,
        Summoned = 61,
        SpSummoning = 62,
        SpSummoned = 63,
        FlipSummoning = 64,
        FlipSummoned = 65,
        Chaining = 70,
        Chained = 71,
        ChainSolving = 72,
        ChainSolved = 73,
        ChainEnd = 74,
        ChainNegated = 75,
        ChainDisabled = 76,
        CardSelected = 80,
        RandomSelected = 81,
        BecomeTarget = 83,
        Draw = 90,
        Damage = 91,
        Recover = 92,
        Equip = 93,
        LpUpdate = 94,
        Unequip = 95,
        CardTarget = 96,
        CancelTarget = 97,
        PayLpCost = 100,
        AddCounter = 101,
        RemoveCounter = 102,
        Attack = 110,
        Battle = 111,
        AttackDisabled = 112,
        DamageStepStart = 113,
        DamageStepEnd = 114,
        MissedEffect = 120,
        BeChainTarget = 121,
        CreateRelation = 122,
        ReleaseRelation = 123,
        TossCoin = 130,
        TossDice = 131,
        RockPaperScissors = 132,
        HandResult = 133,
        AnnounceRace = 140,
        AnnounceAttrib = 141,
        AnnounceCard = 142,
        AnnounceNumber = 143,
        CardHint = 160,
        TagSwap = 161,
        ReloadField = 162,
        AiName = 163,
        ShowHint = 164,
        PlayerHint = 165,
        MatchKill = 170,
        CustomMsg = 180,
        DuelWinner = 200,
        sibyl_chat = 230,
        sibyl_replay = 231,
        sibyl_clear = 232,
        sibyl_delay = 233,
        sibyl_book = 234,
        sibyl_name = 235,
        sibyl_quit = 236,
    }
    public enum DuelHint
    {
        Event = 1,
        Message = 2,
        SelectMsg = 3,
        OpSelected = 4,
        Effect = 5,
        Race = 6,
        Attribute = 7,
        Code = 8,
        Number = 9,
        Card = 10,
        Zone = 11
    }

    public enum DuelPhase
    {
        Draw = 0x01,
        Standby = 0x02,
        Main1 = 0x04,
        BattleStart = 0x08,
        BattleStep = 0x10,
        Damage = 0x20,
        DamageCal = 0x40,
        Battle = 0x80,
        Main2 = 0x100,
        End = 0x200
    }
    public enum SearchCode
    {
        OPCODE_ADD = 0x40000000,
        OPCODE_SUB = 0x40000001,
        OPCODE_MUL = 0x40000002,
        OPCODE_DIV = 0x40000003,
        OPCODE_AND = 0x40000004,
        OPCODE_OR = 0x40000005,
        OPCODE_NEG = 0x40000006,
        OPCODE_NOT = 0x40000007,
        OPCODE_ISCODE = 0x40000100,
        OPCODE_ISSETCARD = 0x40000101,
        OPCODE_ISTYPE = 0x40000102,
        OPCODE_ISRACE = 0x40000103,
        OPCODE_ISATTRIBUTE = 0x40000104,
    }

    public enum DuelMode
    {
        TestMode = 0x1,
        AttackFirstTurn = 0x2,
        OldReplay = 0x4,
        ObsoleteRuling = 0x8,
        PseudoShuffle = 0x10,
        TagMode = 0x20,
        SimpleAI = 0x40,
        ReturnDeckTop = 0x80
    }

    public enum DuelActivity
    {
        Summon = 1,
        NormalSummon = 2,
        SpSummon = 3,
        FlipSummon = 4,
        Attack = 5,
        BattlePhase = 6,
        Chain = 7
    }

    public enum TwoNameCards
    {
        CARD_MARINE_DOLPHIN = 78734254,
        CARD_TWINKLE_MOSS = 13857930,
    }

}