import { Button } from "antd";
import { useSnapshot } from "valtio";

import { matStore } from "@/stores";
import { Footer, genModal, ReactFcWithOnResult, Title } from "@/ui/Shared";

interface Props {
  msg: string;
}
interface Result {
  isOk: boolean;
}

const Content: ReactFcWithOnResult<Props, Result> = ({ msg, onResult }) => {
  const { hint } = useSnapshot(matStore);
  const preHintMsg = hint?.esHint ?? "";
  return (
    <>
      <Title>{`${preHintMsg} ${msg}`}</Title>
      <div style={{ height: 40 }}></div>
      <Footer>
        <Button onClick={() => onResult({ isOk: false })}>取消</Button>
        <Button type="primary" onClick={() => onResult({ isOk: true })}>
          确认
        </Button>
      </Footer>
    </>
  );
};

export const showYesNoModal = genModal({ Content });

// @ts-ignore
window.showYesNoModal = showYesNoModal;
