import { ygopro } from "@/api";
import { roomStore } from "@/stores";

export default function handleHsPlayerEnter(pb: ygopro.YgoStocMsg) {
  const name = pb.stoc_hs_player_enter.name;
  const pos = pb.stoc_hs_player_enter.pos;

  if (pos > 1) {
    console.log("Currently only supported 2v2 mode.");
  } else if (pos < roomStore.players.length) {
    roomStore.players[pos].name = name;
  } else {
    roomStore.players.push({
      name,
      state: ygopro.StocHsPlayerChange.State.NO_READY,
    });
  }
}
