import React, { Suspense } from "react";
import {
  createBrowserRouter,
  createRoutesFromElements,
  Route,
  RouterProvider,
} from "react-router-dom";

import { NeosLayout } from "./Layout";
import LazyLoad, { Loading } from "./LazyLoad";

const Start = React.lazy(() => import("./Start"));
const Match = React.lazy(() => import("./Match"));
const WaitRoom = React.lazy(() => import("./WaitRoom"));
const Mora = React.lazy(() => import("./Mora"));
const NeosDuel = React.lazy(() => import("./Duel/Main"));
const Replay = React.lazy(() => import("./Replay"));
const SSO = React.lazy(() => import("./SSO"));
const Home = React.lazy(() => import("./Home"));

// TODO: finish this
const _router = createBrowserRouter([
  {
    path: "/",
    element: <NeosLayout />,
    children: [
      {
        path: "/",
        element: <LazyLoad lazy={<Start />} />,
      },
      {
        path: "/match",
        element: <LazyLoad lazy={<Match />} />,
      },
    ],
  },
]);

// 暂且先这么写，为后重构为createBrowserRouter打基础
const router = createBrowserRouter(
  createRoutesFromElements(
    <Route path="/" element={<NeosLayout />}>
      <Route path="/" element={<LazyLoad lazy={<Start />} />} />
      <Route path="/home" element={<LazyLoad lazy={<Home />} />} />
      <Route path="/match" element={<LazyLoad lazy={<Match />} />} />
      <Route
        path="/room/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <WaitRoom />
          </Suspense>
        }
      />
      <Route
        path="/mora/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <Mora />
          </Suspense>
        }
      />
      <Route path="/replay" element={<LazyLoad lazy={<Replay />} />} />
      <Route
        path="/duel/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <NeosDuel />
          </Suspense>
        }
      />
      <Route path="/sso/*" element={<LazyLoad lazy={<SSO />} />} />
    </Route>
  )
);

export const NeosRouter = () => <RouterProvider router={router} />;
