import { ygopro } from "@/api";
import { AudioActionType, playEffect } from "@/infra/audio";
import { fetchEsHintMeta } from "@/stores";

export default (_: ygopro.StocGameMessage.MsgSpSummoned) => {
  // 这里服务器没有传特殊召唤的怪兽的ID，
  // 所以如果要判断是否是衍生物召唤的话，需要从`MsgSpSummoning`中获取
  // 并保存，在处理这个消息的时候再取出来进行判断。
  //
  // 这里暂时在所有情况下都播放`SOUND_SPECIAL_SUMMON`
  playEffect(AudioActionType.SOUND_SPECIAL_SUMMON);
  fetchEsHintMeta({ originMsg: 1606 });
};
