﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms.VisualStyles;
using System.IO;
using NLua;
using System.Windows.Forms;
using System.Drawing;

namespace cardvisa
{
    public class LuaTask
    {
        Lua myLua = new Lua();
        private string fileName { get; set; }

    }
    public class LuaDebug
    {
        public Form cons = new Form();
        public TextBox tbxlog = new TextBox();        
        public LuaDebug() {
            cons.Text = "调试输出";
            cons.Size = new Size(400,250);
            cons.StartPosition = FormStartPosition.CenterParent;
            tbxlog.Location = new Point(0, 0);
            tbxlog.Multiline = true;
            tbxlog.Dock = DockStyle.Fill;            
            cons.Controls.Add(tbxlog);
        }
        public void Show() { cons.Show(); }
        public void Close() { cons.Close(); }
        public void Print(string text) { tbxlog.Text += text; }        
    }
    public class TaskFile
    {
        private string fileFullName { get; set; }
        public TaskFile() { }
        public TaskFile(string path) { fileFullName = path; }
        public string GetName() { return Path.GetFileNameWithoutExtension(fileFullName); }
        public string GetNameEx() { return Path.GetFileName(fileFullName); }
        public string GetExtension() { return Path.GetExtension(fileFullName); }
        public string GetFullName() { return fileFullName; }
        //public string GetDirectoryName() { return Path.get; }
        public string GetDirectoryFullName() { return Path.GetDirectoryName(fileFullName); }

        

        public bool MakeDir(string path)
        {
            if (!Directory.Exists(path)) { Directory.CreateDirectory(path); return true; } else { return false; }
        }
        public bool RemoveDir(string path)
        {
            if (Directory.Exists(path)) { Directory.Delete(path, true); return true; } else { return false; }
        }
        public bool Copy(string source, string target)
        {
            if (File.Exists(source) && !File.Exists(target)) { File.Copy(source, target); return true; } else { return false; }
        }
        public bool Move(string source, string target)
        {
            if (File.Exists(source) && !File.Exists(target)) { File.Move(source, target); return true; } else { return false; }
        }
        public bool Rename(string source, string target)
        {
            if (File.Exists(source) && !File.Exists(target)) { File.Move(source, target); return true; } else { return false; }
        }
        public bool Delete(string source)
        {
            if (File.Exists(source)) { File.Delete(source); return true; } else { return false; }
        }


        public string ReadText(string source) { 
            if (File.Exists(source)) {  return File.ReadAllText(source,Encoding.UTF8); } else { return null; }
        }
        public string[] ReadAllLines(string source) {
            if (File.Exists(source)) { return File.ReadAllLines(source); } else { return null; }
        }
        public bool AppendText(string source, string text)
        {
            if (File.Exists(source)) {
                using (StreamWriter sw = File.AppendText(source)) { sw.WriteLine(text); }
                return true; 
            } else { return false; }
        }
        public bool CreateText(string source, string text)
        {
            if (File.Exists(source)) { File.CreateText(source).WriteLine(text); return true; } else { return false; }
        }
        public bool ReaplaceText(string path, string patt1, string patt2)
        {
            if (File.Exists(path)) { File.CreateText(path).WriteLine(File.ReadAllText(path).Replace(patt1, patt2)); return true; } else { return false; }
        }
    }
}
