import { CheckCircleFilled } from "@ant-design/icons";
import { Avatar, Button, ConfigProvider, Skeleton, Space } from "antd";
import classNames from "classnames";
import { useState } from "react";
import { type LoaderFunction, useLoaderData } from "react-router-dom";
import { useSnapshot } from "valtio";

import { accountStore } from "@/stores";
import { Background, IconFont, Select } from "@/ui/Shared";

import { Chat } from "./Chat";
import styles from "./index.module.scss";

interface Params {
  player?: string;
  passWd?: string;
  ip?: string;
}

export const loader: LoaderFunction = async ({ params }) => params;

export const Component: React.FC = () => {
  const _params = useLoaderData<Params>();
  const { user } = useSnapshot(accountStore);
  const [collapsed, setCollapsed] = useState(false);
  return (
    <ConfigProvider
      theme={{
        components: {
          Button: {
            lineWidth: 0,
            fontSizeLG: 14,
            fontSize: 12,
            colorBgContainer: "hsla(0, 0%, 100%, 0.05)",
            colorPrimaryHover: "#ccc",
            colorPrimaryActive: "#aaa",
          },
        },
      }}
    >
      <div
        className={classNames(styles.container, {
          [styles.collapsed]: collapsed,
        })}
      >
        <Background />
        <div className={styles.sider}>
          <Button
            className={styles["btn-sider"]}
            icon={<IconFont type="icon-side-bar-fill" size={16} />}
            onClick={() => setCollapsed(!collapsed)}
          />

          <Chat />
        </div>
        <div className={styles.main}>
          <Space>
            <Select
              title="卡组"
              showSearch
              defaultValue="lucy"
              style={{ width: 300 }}
              options={[
                { value: "jack", label: "Jack" },
                { value: "lucy", label: "Lucy" },
                { value: "Yiminghe", label: "yiminghe" },
                { value: "disabled", label: "Disabled", disabled: true },
              ]}
            />
            <div className={styles.watch}>
              <span className={styles["btn-watch"]}>
                <IconFont type="icon-record" size={18} />
                加入观战
              </span>
              <Avatar.Group className={styles["avatars-watch"]}>
                <Avatar
                  src="https://xsgames.co/randomusers/avatar.php?g=pixel&key=1"
                  size="small"
                />
                <Avatar style={{ backgroundColor: "#f56a00" }} size="small">
                  K
                </Avatar>
                <Avatar style={{ backgroundColor: "#87d068" }} size="small" />
              </Avatar.Group>
            </div>
          </Space>
          <div className={styles["both-side-container"]}>
            <div className={classNames(styles["side-box"], styles.me)}>
              <div className={styles.inner}></div>
              <div style={{ position: "relative" }}>
                <Avatar src={user?.avatar_url} size={48} />
                <CheckCircleFilled className={styles.check} />
              </div>
              <div className={styles.name}>Timel#6675</div>
              <Button size="large" className={styles["btn-join"]}>
                决斗准备
              </Button>
            </div>
            {/* <div className={styles.battle}>
            <IconFont type="icon-battle" size={32} />
          </div> */}
            <div className={classNames(styles["side-box"], styles.op)}>
              <div className={styles.inner}></div>
              <Avatar size={48} />
              <div className={styles.name}>
                <Skeleton.Input size="small" />
              </div>
              <Button size="large" className={styles["btn-join"]}>
                加入决斗
              </Button>
            </div>
          </div>
        </div>
      </div>
    </ConfigProvider>
  );
};
