import { Button, Input } from "antd";

import { IconFont } from "../Shared";
import styles from "./Chat.module.scss";

export const Chat: React.FC = () => {
  return (
    <div className={styles.chat}>
      <div className={styles.dialogs}>
        <DialogItem
          name="愧心Kanzo"
          time="00:34:28"
          content="白银城连抽了三张⏰"
        />
        <DialogItem
          name="愧心Kanzo"
          time="00:34:28"
          content="白银城连抽了三张⏰"
        />
      </div>
      <div className={styles.input}>
        <Input.TextArea
          bordered={false}
          autoSize
          placeholder="请输入聊天内容"
        />
        <Button type="text" icon={<IconFont type="icon-send" size={16} />} />
      </div>
    </div>
  );
};

const DialogItem: React.FC<{
  name: string;
  time: string;
  content: string;
}> = ({ name, time, content }) => {
  return (
    <div className={styles.item}>
      <div className={styles.name}>
        {name}
        <span className={styles.time}>{time}</span>
      </div>
      <div className={styles.content}>{content}</div>
    </div>
  );
};
