import "./index.scss";

import React from "react";
import { useNavigate } from "react-router-dom";

import { useConfig } from "@/config";
const NeosConfig = useConfig();

const Start: React.FC = () => {
  const navigate = useNavigate();
  return (
    <>
      <div className="mycard-header">
        <a className="mycard-logo" href="https://mycard.moe/">
          <img
            src={`${NeosConfig.assetsPath}/mycard_logo.png`}
            alt="MyCard"
            width={130}
            height={40}
          />
        </a>
      </div>
      <div className="wrapper">
        <div role="banner" className="neos-header">
          <div>
            <h1>
              <img
                src={`${NeosConfig.assetsPath}/neos_logo.png`}
                width={540}
                height={250}
                alt="YGO NEOS"
              />
            </h1>
            <button
              onClick={() => {
                navigate("/sso");
              }}
            >
              登录萌卡进行游玩
            </button>
          </div>
        </div>
      </div>
    </>
  );
};

export default Start;
