import React, { Suspense } from "react";
import { Route, Routes } from "react-router-dom";

import LazyLoad, { Loading } from "./LazyLoad";

const Start = React.lazy(() => import("./Start"));
const Match = React.lazy(() => import("./Match"));
const WaitRoom = React.lazy(() => import("./WaitRoom"));
const Mora = React.lazy(() => import("./Mora"));
const NeosDuel = React.lazy(() => import("./Duel/Main"));
const Replay = React.lazy(() => import("./Replay"));
const SSO = React.lazy(() => import("./SSO"));
const Home = React.lazy(() => import("./Home"));

export default function () {
  return (
    <Routes>
      <Route path="/" element={<LazyLoad lazy={<Start />} />} />
      <Route path="/home" element={<LazyLoad lazy={<Home />} />} />
      <Route path="/match" element={<LazyLoad lazy={<Match />} />} />
      <Route
        path="/room/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <WaitRoom />
          </Suspense>
        }
      />
      <Route
        path="/mora/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <Mora />
          </Suspense>
        }
      />
      <Route path="/replay" element={<LazyLoad lazy={<Replay />} />} />
      <Route
        path="/duel/:player/:passWd/:ip"
        element={
          <Suspense fallback={<Loading />}>
            <NeosDuel />
          </Suspense>
        }
      />
      <Route path="/sso/*" element={<LazyLoad lazy={<SSO />} />} />
    </Routes>
  );
}
