import {
  Button,
  Checkbox,
  Form,
  Input,
  InputNumber,
  Select,
  type SelectProps,
} from "antd";
import { useState } from "react";

import { fetchStrings, Region } from "@/api";
import {
  Attribute2StringCodeMap,
  Race2StringCodeMap,
  Type2StringCodeMap,
} from "@/common";
import { FtsConditions } from "@/middleware/sqlite/fts";

import styles from "./Filter.module.scss";

const options: SelectProps["options"] = [];

const levels = Array.from({ length: 12 }).map((_, index) => index + 1);

for (let i = 10; i < 36; i++) {
  options.push({
    label: i.toString(36) + i,
    value: i.toString(36) + i,
  });
}

export const Filter: React.FC<{
  conditions: FtsConditions;
  applyCallback: (newConditons: FtsConditions) => void;
}> = ({ conditions, applyCallback }) => {
  const [newConditions, setNewConditions] = useState<FtsConditions>({});
  return (
    <>
      <div className={styles.title}>卡片筛选</div>
      <div className={styles.form}>
        <div className={styles.item}>
          <div className={styles["item-name"]}>属性</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={Array.from(Attribute2StringCodeMap.entries()).map(
              ([key, value]) => ({
                value: key,
                label: fetchStrings(Region.System, value),
              })
            )}
            defaultValue={conditions.attributes ?? []}
            onChange={(values) => {
              // @ts-ignore
              setNewConditions((prev) => {
                prev.attributes = values;
                return prev;
              });
            }}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>星级</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={levels.map((level) => ({
              value: level,
              label: level.toString(),
            }))}
            defaultValue={conditions.levels ?? []}
            onChange={(values) => {
              // @ts-ignore
              setNewConditions((prev) => {
                prev.levels = values;
                return prev;
              });
            }}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>种族</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={Array.from(Race2StringCodeMap.entries()).map(
              ([key, value]) => ({
                value: key,
                label: fetchStrings(Region.System, value),
              })
            )}
            defaultValue={conditions.races ?? []}
            onChange={(values) => {
              // @ts-ignore
              setNewConditions((prev) => {
                prev.races = values;
                return prev;
              });
            }}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>类型</div>
          <Select
            mode="multiple"
            allowClear
            style={{ width: "100%" }}
            placeholder="Please select"
            options={Array.from(Type2StringCodeMap.entries()).map(
              ([key, value]) => ({
                value: key,
                label: fetchStrings(Region.System, value),
              })
            )}
            defaultValue={conditions.types ?? []}
            onChange={(values) => {
              // @ts-ignore
              setNewConditions((prev) => {
                prev.types = values;
                return prev;
              });
            }}
          />
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>攻击力</div>
          <div className={styles.number}>
            <InputNumber
              defaultValue={conditions.atk?.[0]}
              onChange={(value) => {
                setNewConditions((prev) => {
                  // TODO: 下面这些逻辑有时间可以去重一下
                  if (value === null) {
                    prev.atk = undefined;
                  } else {
                    if (prev.atk) {
                      prev.atk[0] = value;
                    } else {
                      prev.atk = [value, 9999];
                    }
                  }
                  return prev;
                });
              }}
            />
            <span className={styles.divider}>~</span>
            <InputNumber
              defaultValue={conditions.atk?.[1]}
              onChange={(value) => {
                setNewConditions((prev) => {
                  if (value === null) {
                    prev.atk = undefined;
                  } else {
                    if (prev.atk) {
                      prev.atk[1] = value;
                    } else {
                      prev.atk = [0, value];
                    }
                  }
                  return prev;
                });
              }}
            />
          </div>
        </div>
        <div className={styles.item}>
          <div className={styles["item-name"]}>防御力</div>
          <div className={styles.number}>
            <InputNumber
              defaultValue={conditions.def?.[0]}
              onChange={(value) => {
                setNewConditions((prev) => {
                  if (value === null) {
                    prev.def = undefined;
                  } else {
                    if (prev.def) {
                      prev.def[0] = value;
                    } else {
                      prev.def = [value, 9999];
                    }
                  }

                  return prev;
                });
              }}
            />
            <span className={styles.divider}>~</span>
            <InputNumber
              defaultValue={conditions.def?.[1]}
              onChange={(value) => {
                setNewConditions((prev) => {
                  if (value === null) {
                    prev.def = undefined;
                  } else {
                    if (prev.def) {
                      prev.def[1] = value;
                    } else {
                      prev.def = [0, value];
                    }
                  }

                  return prev;
                });
              }}
            />
          </div>
        </div>
      </div>
      <div className={styles.btns}>
        <Button type="primary" onClick={() => applyCallback(newConditions)}>
          确定
        </Button>
        <Button type="text">取&nbsp;消</Button>
      </div>
    </>
  );
};
