import { createFromIconfontCN } from "@ant-design/icons";

const _IconFont = createFromIconfontCN({
  scriptUrl: ["//at.alicdn.com/t/c/font_4188978_x6rqg2kz3fa.js"],
});

export const IconFont: React.FC<{
  type: string;
  size?: number;
  color?: string;
  style?: React.CSSProperties;
}> = ({ type, size = "inherit", style, color = "inherit" }) => (
  <_IconFont type={type} style={{ ...style, fontSize: size, color }} />
);
