import React from "react";
import { useSnapshot } from "valtio";

import { useConfig } from "@/config";
import { accountStore } from "@/stores";

import styles from "./index.module.scss";

const NeosConfig = useConfig();

const Home: React.FC = () => {
  const { user } = useSnapshot(accountStore);

  const onLogout = () => {}; // TODO

  return (
    <>
      <div className={styles["account-header"]}>
        <a href="https://mycard.moe/">
          <img
            src={`${NeosConfig.assetsPath}/mycard_logo.png`}
            alt="MyCard"
            width={130}
            height={40}
          />
        </a>
        <div className={styles["header-user"]}>
          <img
            src={
              user?.avatar_url ?? `${NeosConfig.assetsPath}/default-avatar.png`
            }
            alt={user?.username}
            height={40}
          />
          <a className={styles["header-user-btn"]} href={NeosConfig.profileUrl}>
            个人中心
          </a>
          <span className={styles.sep}>|</span>
          <a
            className={styles["header-user-btn"]}
            href="javascript:void(0)"
            onClick={onLogout}
          >
            登出
          </a>
        </div>
      </div>
      <div className={styles.container}>
        <div className={styles.bg}></div>
        <div className={styles.box}>
          <p>欢迎来到NEOS</p>
          <button>娱乐匹配</button>
          <button>竞技匹配</button>
          <button>自定义匹配</button>
          <button>人机对战</button>
          <button>录像回放</button>
          <button>卡组编辑</button>
        </div>
      </div>
    </>
  );
};

export default Home;
