import axios from 'axios';
import { PicInfo } from './src/def';

const endpoint = process.env.ENDPOINT || 'https://konachan.com/post.json';
const page = process.env.PAGE || '1';
const limit = process.argv[2] || '10';
const tags = process.argv.slice(3).join('+') || undefined;

async function main() {
  const { data } = await axios.get<PicInfo[]>(endpoint, {
    responseType: 'json',
    params: {
      tags,
      page,
      limit,
    },
  });
  data.forEach((pic) => console.log(pic.file_url));
}
main();
