import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppComponent } from './app.component';
import { ToastComponent } from './toast/toast.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { environment } from '../environments/environment';
import { ApiModule } from './api/api.module';
import { HttpClientModule } from '@angular/common/http';

@NgModule({
  declarations: [AppComponent, ToastComponent],
  imports: [
    BrowserModule,
    NgbModule,
    FormsModule,
    HttpClientModule,
    ApiModule.forRoot({
      rootUrl: environment.production
        ? 'https://blapi.wenaiwu.net'
        : 'http://localhost:3000',
    }),
  ],
  providers: [],
  bootstrap: [AppComponent],
})
export class AppModule {}
