/* tslint:disable */
/* eslint-disable */
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse } from '@angular/common/http';
import { BaseService } from '../base-service';
import { ApiConfiguration } from '../api-configuration';
import { StrictHttpResponse } from '../strict-http-response';
import { RequestBuilder } from '../request-builder';
import { Observable } from 'rxjs';
import { map, filter } from 'rxjs/operators';

import { WhitelistAccountResultDtoPaginatedReturnMessageDto } from '../models/whitelist-account-result-dto-paginated-return-message-dto';

@Injectable({
  providedIn: 'root',
})
export class WhitelistAccountService extends BaseService {
  constructor(
    config: ApiConfiguration,
    http: HttpClient
  ) {
    super(config, http);
  }

  /**
   * Path part for operation whitelistAccountControllerFindAll
   */
  static readonly WhitelistAccountControllerFindAllPath = '/api/whitelist-account';

  /**
   * Find all WhitelistAccount.
   *
   *
   *
   * This method provides access to the full `HttpResponse`, allowing access to response headers.
   * To access only the response body, use `whitelistAccountControllerFindAll()` instead.
   *
   * This method doesn't expect any request body.
   */
  whitelistAccountControllerFindAll$Response(params?: {

    /**
     * The nth page, starting with 1.
     */
    pageCount?: number;

    /**
     * Records per page.
     */
    recordsPerPage?: number;
    id?: number;

    /**
     * QQ account number.
     */
    account?: string;
    random?: number;
  }): Observable<StrictHttpResponse<WhitelistAccountResultDtoPaginatedReturnMessageDto>> {

    const rb = new RequestBuilder(this.rootUrl, WhitelistAccountService.WhitelistAccountControllerFindAllPath, 'get');
    if (params) {
      rb.query('pageCount', params.pageCount, {});
      rb.query('recordsPerPage', params.recordsPerPage, {});
      rb.query('id', params.id, {});
      rb.query('account', params.account, {});
      rb.query('random', params.random, {});
    }

    return this.http.request(rb.build({
      responseType: 'json',
      accept: 'application/json'
    })).pipe(
      filter((r: any) => r instanceof HttpResponse),
      map((r: HttpResponse<any>) => {
        return r as StrictHttpResponse<WhitelistAccountResultDtoPaginatedReturnMessageDto>;
      })
    );
  }

  /**
   * Find all WhitelistAccount.
   *
   *
   *
   * This method provides access to only to the response body.
   * To access the full response (for headers, for example), `whitelistAccountControllerFindAll$Response()` instead.
   *
   * This method doesn't expect any request body.
   */
  whitelistAccountControllerFindAll(params?: {

    /**
     * The nth page, starting with 1.
     */
    pageCount?: number;

    /**
     * Records per page.
     */
    recordsPerPage?: number;
    id?: number;

    /**
     * QQ account number.
     */
    account?: string;
    random?: number;
  }): Observable<WhitelistAccountResultDtoPaginatedReturnMessageDto> {

    return this.whitelistAccountControllerFindAll$Response(params).pipe(
      map((r: StrictHttpResponse<WhitelistAccountResultDtoPaginatedReturnMessageDto>) => r.body as WhitelistAccountResultDtoPaginatedReturnMessageDto)
    );
  }

}
