/* tslint:disable */
/* eslint-disable */
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse } from '@angular/common/http';
import { BaseService } from '../base-service';
import { ApiConfiguration } from '../api-configuration';
import { StrictHttpResponse } from '../strict-http-response';
import { RequestBuilder } from '../request-builder';
import { Observable } from 'rxjs';
import { map, filter } from 'rxjs/operators';

import { BlacklistAccountResultDtoPaginatedReturnMessageDto } from '../models/blacklist-account-result-dto-paginated-return-message-dto';

@Injectable({
  providedIn: 'root',
})
export class BlacklistAccountService extends BaseService {
  constructor(
    config: ApiConfiguration,
    http: HttpClient
  ) {
    super(config, http);
  }

  /**
   * Path part for operation blacklistAccountControllerFindAll
   */
  static readonly BlacklistAccountControllerFindAllPath = '/api/blacklist';

  /**
   * Find all BlacklistAccount.
   *
   *
   *
   * This method provides access to the full `HttpResponse`, allowing access to response headers.
   * To access only the response body, use `blacklistAccountControllerFindAll()` instead.
   *
   * This method doesn't expect any request body.
   */
  blacklistAccountControllerFindAll$Response(params?: {

    /**
     * The nth page, starting with 1.
     */
    pageCount?: number;

    /**
     * Records per page.
     */
    recordsPerPage?: number;
    id?: number;

    /**
     * QQ account number.
     */
    account?: string;

    /**
     * Blacklist ID.
     */
    blacklistId?: string;
  }): Observable<StrictHttpResponse<BlacklistAccountResultDtoPaginatedReturnMessageDto>> {

    const rb = new RequestBuilder(this.rootUrl, BlacklistAccountService.BlacklistAccountControllerFindAllPath, 'get');
    if (params) {
      rb.query('pageCount', params.pageCount, {});
      rb.query('recordsPerPage', params.recordsPerPage, {});
      rb.query('id', params.id, {});
      rb.query('account', params.account, {});
      rb.query('blacklistId', params.blacklistId, {});
    }

    return this.http.request(rb.build({
      responseType: 'json',
      accept: 'application/json'
    })).pipe(
      filter((r: any) => r instanceof HttpResponse),
      map((r: HttpResponse<any>) => {
        return r as StrictHttpResponse<BlacklistAccountResultDtoPaginatedReturnMessageDto>;
      })
    );
  }

  /**
   * Find all BlacklistAccount.
   *
   *
   *
   * This method provides access to only to the response body.
   * To access the full response (for headers, for example), `blacklistAccountControllerFindAll$Response()` instead.
   *
   * This method doesn't expect any request body.
   */
  blacklistAccountControllerFindAll(params?: {

    /**
     * The nth page, starting with 1.
     */
    pageCount?: number;

    /**
     * Records per page.
     */
    recordsPerPage?: number;
    id?: number;

    /**
     * QQ account number.
     */
    account?: string;

    /**
     * Blacklist ID.
     */
    blacklistId?: string;
  }): Observable<BlacklistAccountResultDtoPaginatedReturnMessageDto> {

    return this.blacklistAccountControllerFindAll$Response(params).pipe(
      map((r: StrictHttpResponse<BlacklistAccountResultDtoPaginatedReturnMessageDto>) => r.body as BlacklistAccountResultDtoPaginatedReturnMessageDto)
    );
  }

}
