/* tslint:disable */
/* eslint-disable */
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse } from '@angular/common/http';
import { BaseService } from '../base-service';
import { ApiConfiguration } from '../api-configuration';
import { StrictHttpResponse } from '../strict-http-response';
import { RequestBuilder } from '../request-builder';
import { Observable } from 'rxjs';
import { map, filter } from 'rxjs/operators';

import { AdReturnMessageDto } from '../models/ad-return-message-dto';
import { StringReturnMessageDto } from '../models/string-return-message-dto';

@Injectable({
  providedIn: 'root',
})
export class AdService extends BaseService {
  constructor(
    config: ApiConfiguration,
    http: HttpClient
  ) {
    super(config, http);
  }

  /**
   * Path part for operation adControllerGetAd
   */
  static readonly AdControllerGetAdPath = '/api/ad/random';

  /**
   * Get ad.
   *
   *
   *
   * This method provides access to the full `HttpResponse`, allowing access to response headers.
   * To access only the response body, use `adControllerGetAd()` instead.
   *
   * This method doesn't expect any request body.
   */
  adControllerGetAd$Response(params?: {
    id?: number;
  }): Observable<StrictHttpResponse<AdReturnMessageDto>> {

    const rb = new RequestBuilder(this.rootUrl, AdService.AdControllerGetAdPath, 'get');
    if (params) {
      rb.query('id', params.id, {});
    }

    return this.http.request(rb.build({
      responseType: 'json',
      accept: 'application/json'
    })).pipe(
      filter((r: any) => r instanceof HttpResponse),
      map((r: HttpResponse<any>) => {
        return r as StrictHttpResponse<AdReturnMessageDto>;
      })
    );
  }

  /**
   * Get ad.
   *
   *
   *
   * This method provides access to only to the response body.
   * To access the full response (for headers, for example), `adControllerGetAd$Response()` instead.
   *
   * This method doesn't expect any request body.
   */
  adControllerGetAd(params?: {
    id?: number;
  }): Observable<AdReturnMessageDto> {

    return this.adControllerGetAd$Response(params).pipe(
      map((r: StrictHttpResponse<AdReturnMessageDto>) => r.body as AdReturnMessageDto)
    );
  }

  /**
   * Path part for operation adControllerClickAd
   */
  static readonly AdControllerClickAdPath = '/api/ad/click/{id}';

  /**
   * Click ad.
   *
   *
   *
   * This method provides access to the full `HttpResponse`, allowing access to response headers.
   * To access only the response body, use `adControllerClickAd()` instead.
   *
   * This method doesn't expect any request body.
   */
  adControllerClickAd$Response(params: {
    id: number;
  }): Observable<StrictHttpResponse<StringReturnMessageDto>> {

    const rb = new RequestBuilder(this.rootUrl, AdService.AdControllerClickAdPath, 'get');
    if (params) {
      rb.path('id', params.id, {});
    }

    return this.http.request(rb.build({
      responseType: 'json',
      accept: 'application/json'
    })).pipe(
      filter((r: any) => r instanceof HttpResponse),
      map((r: HttpResponse<any>) => {
        return r as StrictHttpResponse<StringReturnMessageDto>;
      })
    );
  }

  /**
   * Click ad.
   *
   *
   *
   * This method provides access to only to the response body.
   * To access the full response (for headers, for example), `adControllerClickAd$Response()` instead.
   *
   * This method doesn't expect any request body.
   */
  adControllerClickAd(params: {
    id: number;
  }): Observable<StringReturnMessageDto> {

    return this.adControllerClickAd$Response(params).pipe(
      map((r: StrictHttpResponse<StringReturnMessageDto>) => r.body as StringReturnMessageDto)
    );
  }

}
