import 'reflect-metadata';
import { ArrayValue, GenericMap, Key, MapValue, StringDict } from './def';

export class Reflector<M extends StringDict, AM extends StringDict> {
  get<K extends Key<GenericMap<M, AM>>>(
    metadataKey: K,
    instance: any,
    key?: string | symbol,
  ): MapValue<M, AM, K> {
    const instanceClass = instance.constructor;
    if (key) {
      return Reflect.getMetadata(metadataKey, instanceClass, key);
    } else {
      return Reflect.getMetadata(metadataKey, instanceClass);
    }
  }

  getArray<K extends Key<M>>(
    metadataKey: K,
    instance: any,
    key?: string | symbol,
  ): ArrayValue<AM, K> {
    return this.get(metadataKey, instance, key) || [];
  }

  getProperty<K extends Key<M>, I = any>(
    metadataKey: K,
    instance: I,
    key: keyof I & (string | symbol),
    alternate: any = instance,
  ): ArrayValue<AM, K> {
    const valueFromClass = this.getArray(metadataKey, alternate);
    const valueFromProperty = this.getArray(metadataKey, instance, key);
    return [...valueFromClass, ...valueFromProperty] as ArrayValue<AM, K>;
  }
}
