# typed-reflector

Metadata reflector with typing support.

## API

### Type Map

Either Reflector or Metadata Setter accepts 2 type arguments. The first one is the type map of common types, while the second one is the type map of arrays.

### Reflector

* `Reflector.get(metadataKey, instance, key)` Fetches the metadata of instance.

* `Reflector.getArray(metadataKey, instance, key)` Fetches the array metadata of instance. Will return empty array if not exists.

* `Reflector.getProperty(metadataKey, instance, key, alternate = instance)` Fetches the array metadata of instance from both class and property. The last parameter is an alternate source object for fetching metadata from class.

### Metadata Setter

* `MetadataSetter.set(metadataKey, value)` Sets and overrides the MetadataSetter.

* `MetadataSetter.append(metadataKey, value)` Append to the the metadata array. The array would be created if not exists.

* `MetadataSetter.appendUnique(metadataKey, value)` Same as above but no duplicate values.

* `MetadataSetter.concat(metadataKey, value)` The value must be an array, and the metadata array would be joined together.


