export function isClass(target: any) {
  if (typeof target !== 'function') {
    return false;
  }
  const proto = target.constructor;
  return proto === Function;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export function getClass(target: any): Function {
  return isClass(target) ? target : getClass(target.constructor);
}
