export type StringDict = Record<string, any>;

export type Key<T> = keyof T & string;

export type ArrayValueMap<AM extends StringDict> = {
  [K in keyof AM]: AM[K][];
};

export type ArrayValue<
  AM extends StringDict,
  K extends Key<ArrayValueMap<AM>>
> = ArrayValueMap<AM>[K];

export type MergeKey<M extends StringDict, AM extends StringDict> =
  | Key<M>
  | Key<AM>;

export type GenericMap<M extends StringDict, AM extends StringDict> = M &
  ArrayValueMap<AM>;

export type MapValue<
  M extends StringDict,
  AM extends StringDict,
  K extends MergeKey<M, AM>
> = K extends Key<AM> ? ArrayValue<AM, K> : K extends Key<M> ? M[K] : never;
