import {
  ClassType,
  RefSym,
  SchemaOptions,
  SchemaReference,
  SchemaType,
} from '../def';

import { Metadata } from '../metadata/metadata';
import {
  SetTransformer,
  transformArray,
  transformDict,
  transformSingle,
} from '../utility/transformer';
import Schema from 'schemastery';
import { kSchema } from '../utility/kschema';
import 'reflect-metadata';

export function SchemaProperty(options: SchemaOptions = {}): PropertyDecorator {
  return (obj, key) => {
    const nativeType = Reflect.getMetadata('design:type', obj, key);
    // const nativeTypeString = getStringFromNativeType(nativeType);
    if (!options.type) {
      if (nativeType !== Array) {
        options.type = nativeType;
      } else {
        options.type = 'any';
      }
    }
    const typeInSchema = (options.type as Schema)?.type;
    if (
      nativeType === Array &&
      options.array !== false &&
      typeInSchema !== 'array' &&
      typeInSchema !== 'tuple'
    ) {
      options.array = true;
    }
    if (
      options.type &&
      typeof options.type !== 'string' &&
      ((options.type as Schema<any>)[kSchema] || options.type[RefSym])
    ) {
      const cl = options.type as ClassType<any>;
      let dec: PropertyDecorator;
      if (options.dict) {
        dec = SetTransformer((value) =>
          transformDict(cl, value, options.array),
        );
      } else if (options.array) {
        dec = SetTransformer((value) => transformArray(cl, value));
      } else {
        dec = SetTransformer((value) => transformSingle(cl, value));
      }
      dec(obj, key);
    }
    return Metadata.set('SchemaMeta', options, 'SchemaMetaKey')(obj, key);
  };
}

export function SchemaRef<S = any, T = S>(
  factory: () => SchemaType<S, T>,
): SchemaReference<S, T> {
  return {
    [RefSym]: true,
    factory,
  };
}
