import { Metadata } from '../metadata/metadata';
import { ClassType, RefSym, SchemaOrReference, SchemaReference } from '../def';
import Schema from 'schemastery';
import _ from 'lodash';
import { kSchema } from './kschema';
import { resolveSchemaType } from '../decorators';

export function SetTransformer(transformer: (val: any) => any) {
  return Metadata.set('Transformer', transformer);
}

export function transformSingle<T>(
  cl: SchemaOrReference<T> | ClassType<T>,
  val: any,
) {
  if (cl[RefSym]) {
    const ref = cl as SchemaReference<T>;
    return transformSingle(resolveSchemaType(ref.factory()), val);
  } else if (cl[kSchema]) {
    const schema = cl as Schema<T>;
    return new schema(val);
  } else {
    return val;
  }
}

export function transformArray<T>(
  cl: SchemaOrReference<T> | ClassType<T>,
  val: any[],
) {
  if (!val) {
    return;
  }
  const result = val.map((v) => transformSingle(cl, v));
  return result;
}

export function transformDict<T>(
  cl: SchemaOrReference<T> | ClassType<T>,
  val: any,
  array: boolean,
) {
  if (!val) {
    return;
  }
  let result: any;
  if (array) {
    result = (val as Record<string, any>[]).map((v) =>
      _.mapValues(v, (_v) => transformSingle(cl, _v)),
    );
  } else {
    result = _.mapValues(val, (_v) => transformSingle(cl, _v));
  }
  return result;
}
