import { RegisterSchema, SchemaProperty } from '../src/decorators';

describe('schema of class extend', () => {
  class MyConfigBase {
    @SchemaProperty({ default: 'bar' })
    foo: string;
  }

  @RegisterSchema()
  class MyConfig extends MyConfigBase {
    constructor(_: any) {
      super();
    }
    @SchemaProperty({ default: 'baz' })
    bar: string;
  }

  it('should have foo and bar', () => {
    const config = new MyConfig({});
    expect(config.foo).toBe('bar');
    expect(config.bar).toBe('baz');
  });
});
