import Schema, { never, number } from 'schemastery';
import { MatrixToUnionArray, MatrixTwist } from './matrix';

export type ClassType<T> = { new (...args: any[]): T };

export type SchemaNativeType =
  | 'string'
  | 'number'
  | 'boolean'
  | 'object'
  | 'any'
  | 'never';

export type SchemaSource<S = any, T = S> =
  | null
  | undefined
  | string
  | number
  | boolean
  | Schema<S, T>
  // eslint-disable-next-line @typescript-eslint/ban-types
  | Function
  | { new (...args: any[]): any };

export interface SchemaReference<S = any, T = S> {
  [RefSym]: true;
  factory: () => SchemaType<S, T>;
}

export type SchemaOrReference<S = any, T = S> =
  | Schema<S, T>
  | SchemaReference<S, T>;

export type SchemaType<S = any, T = S> =
  | SchemaNativeType
  | SchemaSource<S, T>
  | SchemaReference<S, T>;

export type SchemaClassOptions = Schema.Meta<any>;

export interface SchemaOptions extends SchemaClassOptions {
  dict?: boolean | Schema<any, string> | string;
  array?: boolean;
  type?: SchemaType;
}

export type SchemaOptionsDict<T> = { [P in keyof T]?: SchemaOptions };

export const RefSym = Symbol('SchemasteryGenRef');
export const GeneratedSym = Symbol('GeneratedSym');
export const OriginalClassSym = Symbol('OriginalClassSym');

type UnionToIntersection<T> = (T extends any ? (x: T) => any : never) extends (
  x: infer R,
) => any
  ? R
  : never;
type ArrayToUnion<T extends any[]> = T[number];
type Intersecton<T extends any[]> = UnionToIntersection<ArrayToUnion<T>>;
export type AnyClass = { new (...args: any[]): any };
type TypeOf<T> = T extends { new (...args: any[]): infer R } ? R : never;
type ClassesToTypes<A extends any[]> = A extends [infer L, ...infer R]
  ? [TypeOf<L>, ...ClassesToTypes<R>]
  : [];
/*type ClassesToParams<A extends any[]> = A extends [infer L, ...infer R]
  ? [
      L extends new (...params: infer P) => any ? P : never,
      ...ClassesToParams<R>
    ]
  : [];
*/
export type FusionClass<A extends AnyClass[]> =
  new () => //...args: MatrixToUnionArray<MatrixTwist<ClassesToParams<A>>>
  Intersecton<ClassesToTypes<A>>;
