import { SchemaClassOptions, SchemaOptions, SchemaProperty } from '../def';
import { RegisterSchema } from './register';

export const DefineSchema =
  (
    options: SchemaOptions | SchemaClassOptions = {},
  ): PropertyDecorator & ClassDecorator =>
  (obj, key?) => {
    if (key) {
      return SchemaProperty(options)(obj, key);
    } else {
      return RegisterSchema(options)(obj);
    }
  };

export const SchemaConf = RegisterSchema;
