import { RegisterSchema, SchemaProperty } from '../src/decorators';
import Schema from 'schemastery';

describe('Circular schema', () => {
  @RegisterSchema()
  class MyProperty {
    @SchemaProperty({ default: 'bar' })
    foo: string;

    getFoo() {
      return this.foo;
    }
  }

  @RegisterSchema()
  class MyConfig {
    constructor(_: any) {}
    @SchemaProperty({ type: MyProperty })
    myProperty: MyProperty;
  }

  it('Should be object type', () => {
    const schema = MyConfig as Schema<MyConfig>;
    expect(schema.type).toBe('object');
    expect(schema.dict.myProperty.type).toBe('object');
  });

  it('Should be instance', () => {
    const config = new MyConfig({ myProperty: {} });
    expect(config.myProperty.foo).toBe('bar');
    expect(config.myProperty.getFoo()).toBe('bar');
  });

  it('Should throw if invalid', () => {
    expect(() => new MyConfig({ myProperty: 'boo' })).toThrow();
  });
});
