import Schema from 'schemastery';

export type ClassType<T> = { new (...args: any[]): T };

export type SchemaNativeType =
  | 'string'
  | 'number'
  | 'boolean'
  | 'object'
  | 'any'
  | 'never';

export type SchemaSource =
  | null
  | undefined
  | string
  | number
  | boolean
  | Schema
  // eslint-disable-next-line @typescript-eslint/ban-types
  | Function
  | { new (...args: any[]): any };

export type SchemaType = SchemaNativeType | SchemaSource;

export interface SchemaClassOptions extends Schema.Meta<any> {
  desc?: string;
  allowUnknown?: boolean; // for backward compatibility
}

export interface SchemaOptions extends SchemaClassOptions {
  schema?: Schema<any>;
  dict?: boolean | Schema<any, string> | string;
  array?: boolean;
  type?: SchemaType;
}

export type SchemaOptionsDict<T> = { [P in keyof T]?: SchemaOptions };
