import { Metadata } from '../metadata/metadata';
import { ClassType } from '../def';
import Schema from 'schemastery';
import _ from 'lodash';

export function SetTransformer(transformer: (val: any) => any) {
  return Metadata.set('Transformer', transformer);
}

export function transformSingle<T>(
  cl: ClassType<T> & Partial<Schema>,
  val: any,
) {
  if (typeof cl.type === 'string') {
    return new cl(val);
  } else {
    return val;
  }
}

export function transformArray<T>(cl: ClassType<T>, val: any[]) {
  if (!val) {
    return;
  }
  const result = val.map((v) => transformSingle(cl, v));
  return result;
}

export function transformDict<T>(cl: ClassType<T>, val: any, array: boolean) {
  if (!val) {
    return;
  }
  let result: any;
  if (array) {
    result = (val as Record<string, any>[]).map((v) =>
      _.mapValues(v, (_v) => transformSingle(cl, _v)),
    );
  } else {
    result = _.mapValues(val, (_v) => transformSingle(cl, _v));
  }
  return result;
}
