import { ClassType, SchemaOptions } from '../def/interfaces';
import { getStringFromNativeType } from '../utility/utility';
import { Metadata } from '../metadata/metadata';
import {
  SetTransformer,
  transformArray,
  transformDict,
  transformSingle,
} from '../utility/transformer';
import Schema from 'schemastery';

export function SchemaProperty(options: SchemaOptions = {}): PropertyDecorator {
  return (obj, key) => {
    const nativeType = Reflect.getMetadata('design:type', obj, key);
    const nativeTypeString = getStringFromNativeType(nativeType);
    if (!options.type) {
      if (nativeTypeString && nativeTypeString !== 'array') {
        options.type =
          nativeTypeString === 'class' ? nativeType : nativeTypeString;
      } else {
        options.type = 'any';
      }
    }
    if (
      nativeTypeString === 'array' &&
      options.array !== false &&
      options.schema?.type !== 'tuple'
    ) {
      options.array = true;
    }

    if (
      options.type &&
      typeof options.type !== 'string' &&
      typeof (options.type as Schema<any>).type === 'string'
    ) {
      const cl = options.type as ClassType<any>;
      let dec: PropertyDecorator;
      if (options.dict) {
        dec = SetTransformer((value) =>
          transformDict(cl, value, options.array),
        );
      } else if (options.array) {
        dec = SetTransformer((value) => transformArray(cl, value));
      } else {
        dec = SetTransformer((value) => transformSingle(cl, value));
      }
      dec(obj, key);
    }
    return Metadata.set('SchemaMeta', options, 'SchemaMetaKey')(obj, key);
  };
}

// for backward compatibility
export const DefineSchema = SchemaProperty;
