import Schema from 'schemastery';

export type ClassType<T> = { new <T>(...args: any[]): T };

export type SchemaType =
  | 'string'
  | 'number'
  | 'boolean'
  | 'object'
  | 'any'
  | 'never'
  | { new (...args: any[]): any };

export interface SchemaClassOptions {
  desc?: string;
  required?: boolean;
  hidden?: boolean;
  allowUnknown?: boolean;
  comment?: string;
  default?: any;
}

export interface SchemaOptions extends SchemaClassOptions {
  schema?: Schema<any>;
  dict?: boolean;
  array?: boolean;
  type?: SchemaType;
}

export type SchemaOptionsDict<T> = { [P in keyof T]?: SchemaOptions };
