import { RegisterSchema, SchemaProperty } from '../src/decorators';
import Schema from 'schemastery';

describe('Schema arrays', () => {
  @RegisterSchema()
  class MyProperty {
    @SchemaProperty({ default: 'default' })
    name: string;

    getName() {
      return this.name;
    }
  }

  @RegisterSchema()
  class MyConfig {
    constructor(_: any) {}

    @SchemaProperty({ type: Schema.array(Schema.string()) })
    foo: string[];

    @SchemaProperty({ type: Number })
    bar: number[];

    @SchemaProperty({ type: MyProperty })
    myProperties: MyProperty[];

    @SchemaProperty()
    notArray: string;

    @SchemaProperty({ type: Schema.tuple([Number, String]) })
    myTup: [number, string];

    @SchemaProperty({ type: Schema.tuple([Number, String]), array: true })
    myTupArr: [number, string][];
  }

  const schema = MyConfig as Schema<MyConfig>;

  it('should be correct type', () => {
    expect(schema.dict.foo.type).toEqual('array');
    expect(schema.dict.bar.type).toEqual('array');
    expect(schema.dict.myProperties.type).toEqual('array');
    expect(schema.dict.notArray.type).toEqual('string');
    expect(schema.dict.myTup.type).toEqual('tuple');
    expect(schema.dict.myTupArr.type).toEqual('array');
  });

  it('should be instance of property', () => {
    const config = new MyConfig({ myProperties: [{ name: 'foo' }] });
    expect(config.myProperties[0].getName()).toEqual('foo');
  });
});
