import { RegisterSchema, SchemaProperty } from '../src/decorators';
import { Mixin } from '../src/mixin';

@RegisterSchema()
export class Sleeve {
  @SchemaProperty()
  size: number;

  getSleeveSize() {
    return this.size;
  }
}

@RegisterSchema()
class Dress {
  @SchemaProperty({ type: Sleeve })
  sleeves: Sleeve[];

  @SchemaProperty()
  color: string;

  getColor() {
    return this.color;
  }
}

@RegisterSchema()
class Shirt {
  @SchemaProperty()
  size: string;

  pockets = 3;

  getSize() {
    return this.size;
  }
}

@RegisterSchema()
class Cloth extends Mixin(Dress, Shirt) {
  constructor(data: any) {
    super();
  }

  @SchemaProperty()
  material: string;

  getMaterial() {
    return this.material;
  }
}

describe('Schema registration', () => {
  it('should be instance', () => {
    const cloth = new Cloth({
      color: 'red',
      sleeves: [{ size: 10 }, { size: 20 }],
      size: 'M',
      material: 'cotton',
    });
    expect(cloth.getColor()).toBe('red');
    expect(cloth.getSize()).toBe('M');
    expect(cloth.getMaterial()).toBe('cotton');
    expect(cloth.sleeves[0].getSleeveSize()).toBe(10);
    expect(cloth.sleeves[1].getSleeveSize()).toBe(20);
  });
});
