import { never } from 'schemastery';

type MatrixColumn<A extends any[], P extends any[] = []> = A extends [
  infer L,
  ...infer R
]
  ? [L extends [...P, infer E, ...any[]] ? E : never, ...MatrixColumn<R, P>]
  : [];

type MatrixRow<A extends any[], P extends any[] = []> = A extends [
  ...P,
  infer TargetRow,
  ...any[]
]
  ? TargetRow
  : [];

type MapAny<A extends any[]> = A extends [any, ...infer R]
  ? [any, ...MapAny<R>]
  : [];

type IsLongerOrEqual<A extends any[], B extends any[]> = A extends [
  ...MapAny<B>,
  ...any[]
]
  ? true
  : false;

type ShouldFinish<
  A extends any[],
  P extends any[],
  CP extends any[] = [],
> = IsLongerOrEqual<P, MatrixRow<A, CP>> extends true
  ? IsLongerOrEqual<CP, A> extends true
    ? true
    : ShouldFinish<A, P, [any, ...CP]>
  : false;

export type MatrixTwist<A extends any[], P extends any[] = []> = ShouldFinish<
  A,
  P
> extends true
  ? []
  : [MatrixColumn<A, P>, ...MatrixTwist<A, [any, ...P]>];

export type MatrixToUnionArray<A extends any[]> = A extends [
  infer L,
  ...infer R
]
  ? [L extends any[] ? L[number] : never, ...MatrixToUnionArray<R>]
  : [];
