import Schema from 'schemastery';

export type ClassType<T> = { new (...args: any[]): T };

export type SchemaNativeType =
  | 'string'
  | 'number'
  | 'boolean'
  | 'object'
  | 'any'
  | 'never';

export type SchemaSource<S = any, T = S> =
  | null
  | undefined
  | string
  | number
  | boolean
  | Schema<S, T>
  // eslint-disable-next-line @typescript-eslint/ban-types
  | Function
  | { new (...args: any[]): any };

export interface SchemaReference<S = any, T = S> {
  [RefSym]: true;
  factory: () => SchemaType<S, T>;
}

export type SchemaOrReference<S = any, T = S> =
  | Schema<S, T>
  | SchemaReference<S, T>;

export type SchemaType<S = any, T = S> =
  | SchemaNativeType
  | SchemaSource<S, T>
  | SchemaReference<S, T>;

export type SchemaClassOptions = Schema.Meta<any>;

export interface SchemaOptions extends SchemaClassOptions {
  dict?: boolean | Schema<any, string> | string;
  array?: boolean;
  type?: SchemaType;
}

export type SchemaOptionsDict<T> = { [P in keyof T]?: SchemaOptions };

export const RefSym = Symbol('SchemasteryGenRef');
export const GeneratedSym = Symbol('GeneratedSym');
