import Schema from 'schemastery';

// eslint-disable-next-line @typescript-eslint/ban-types
export function getStringFromNativeType(nativeType: Function) {
  if (!nativeType) {
    return;
  }
  if (typeof (nativeType as Schema<any>).type === 'string') {
    // nested schema
    return 'class';
  }
  const nativeTypeString = nativeType.toString() as string;
  if (!nativeTypeString) {
    return;
  }
  if (nativeTypeString.startsWith('class')) {
    return 'class';
  }
  if (!nativeTypeString.startsWith('function ')) {
    return;
  }
  return nativeType.name?.toLowerCase();
}
