# schemastery-gen

Decorator style of [Schemastery](https://github.com/Shigma/schemastery)

## Install

```ts
npm install schemastery schemastery-gen
```

## Use

The decorator `@RegisterSchema` for class is used to register schema from a class. The registered schema is 100% compatible with schemastery.

```ts

// Don't forget this decorator.
@RegisterSchema({
  desc: 'my desc',
})
export class Config {
  // add this constructor to make sure the class has one parameter on constructor
  constructor(_: any) {
  }

  @DefineSchema({ type: 'number', required: true })
  foo: number;

  // Will automatically infer type from class property.
  @DefineSchema()
  fooAutomated: number;

  @DefineSchema({ type: 'string', default: 'shigma' })
  bar: string;

  @DefineSchema({ type: 'boolean', default: true, hidden: true })
  baz: boolean;

  // Will infer this property as value, but it cannot infer string type. So you have to specify it manually.
  @DefineSchema({ type: 'string', default: ['foo', 'bar'] })
  ant: string[];

  // You may also specify schema manually.
  @DefineSchema({ schema: Schema.string() })
  dream: string;

  // Nested schema.
  @DefineSchema({ type: B })
  bi: B;

  // Type can also be auto-inferred from class property.
  @DefineSchema()
  biInferred: B;

  // Dictionary. Type cannot be auto-inferred.
  @DefineSchema({ type: B, dict: true })
  biDict: Record<string, B>;

  // Combination of dictionary and array. The type cannot be auto-inferred.
  @ObjectSchema(B, { dict: true, array: true })
  biDictArr: Record<string, B>[];
}

// will resolve this class, just like how Schemastery works.
const config = new Config(myConfigObject);
```