import Schema from 'schemastery';

export type ClassType<T> = { new (...args: any[]): T };

export type SchemaType =
  | 'string'
  | 'number'
  | 'boolean'
  | 'object'
  | 'any'
  | 'never'
  | { new (...args: any[]): any };

export interface SchemaClassOptions extends Schema.Meta<any> {
  desc?: string;
  allowUnknown?: boolean; // for backward compatibility
}

export interface SchemaOptions extends SchemaClassOptions {
  schema?: Schema<any>;
  dict?: boolean;
  array?: boolean;
  type?: SchemaType;
}

export type SchemaOptionsDict<T> = { [P in keyof T]?: SchemaOptions };
