import { AnyClass, FusionClass, OriginalClassSym } from './def';
import { reflector } from './metadata/reflector';
import { Metadata } from './metadata/metadata';

export const getOriginalClass = <C extends new (...args: any[]) => any>(
  cls: C,
): C => {
  if (cls[OriginalClassSym]) {
    return cls[OriginalClassSym];
  }
  return cls;
};

function applyMixin(
  mixedClass: AnyClass,
  sourceClass: AnyClass,
  // eslint-disable-next-line @typescript-eslint/ban-types
  visited = new Set<Function>(),
) {
  if (visited.has(sourceClass)) {
    return;
  }
  visited.add(sourceClass);
  Object.getOwnPropertyNames(sourceClass.prototype).forEach((name) => {
    if (!mixedClass.prototype[name]) {
      mixedClass.prototype[name] = sourceClass.prototype[name];
    }
  });
  const schemaKeys = reflector.getArray('SchemaMetaKey', sourceClass);
  for (const name of schemaKeys) {
    const schemaMeta = reflector.get('SchemaMeta', sourceClass, name);
    if (!schemaMeta) {
      continue;
    }
    Metadata.set(
      'SchemaMeta',
      schemaMeta,
      'SchemaMetaKey',
    )(mixedClass.prototype, name);
    const transformerMeta = reflector.get('Transformer', sourceClass, name);
    if (transformerMeta) {
      Metadata.set('Transformer', transformerMeta)(mixedClass.prototype, name);
    }
  }
  const sourceParentClass = Object.getPrototypeOf(sourceClass);
  if (sourceParentClass?.prototype) {
    applyMixin(sourceParentClass, sourceParentClass, visited);
  }
}

export function Mixin<A extends AnyClass[]>(...classes: A): FusionClass<A>;
// eslint-disable-next-line @typescript-eslint/ban-types
export function Mixin<A extends AnyClass[]>(...classes: A): Function {
  const originalClasses = classes.map(getOriginalClass);
  const mixedClass = class MixedClass {};
  // eslint-disable-next-line @typescript-eslint/ban-types
  const visited = new Set<Function>();
  originalClasses.forEach((cls) => applyMixin(mixedClass, cls, visited));
  return mixedClass;
}
