import { Context } from '@satorijs/satori';
import { Registrar } from 'cordis-decorators';
import { selectContext, Selection } from './utility/select-context';

import {
  DefaultContext,
  DefaultState,
  ParameterizedContext,
  Next as KoaNext,
} from 'koa';
import { RouterParamContext } from '@koa/router';

export type KoaContext = ParameterizedContext<
  DefaultState,
  DefaultContext & RouterParamContext<DefaultState, DefaultContext>,
  any
>;

export class SatoriRegistrar<Ctx extends Context> extends Registrar<Ctx> {
  methodDecorators() {
    return {
      ...super.methodDecorators(),
      RouterMethod: this.decorateMethod(
        'route',
        (
          ctx,
          fun: (ctx: KoaContext, Next: KoaNext) => Promise<any>,
          method:
            | 'get'
            | 'post'
            | 'put'
            | 'delete'
            | 'patch'
            | 'options'
            | 'head'
            | 'all',
          path: string,
        ) => {
          const _path = path.startsWith('/') ? path : `/${path}`;
          return ctx.router[method](_path, (koaCtx, next) => fun(koaCtx, next));
        },
      ),
      Ws: this.decorateMethod,
    };
  }

  selectorDecorators() {
    return {
      OnAnywhere: this.decorateTransformer((ctx) => ctx.any()),
      OnNowhere: this.decorateTransformer((ctx) => ctx.never()),
      OnUser: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.user(...values),
      ),
      OnSelf: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.self(...values),
      ),
      OnGuild: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.guild(...values),
      ),
      OnChannel: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.channel(...values),
      ),
      OnPlatform: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.platform(...values),
      ),
      OnPrivate: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.private(...values),
      ),
      OnSelection: this.decorateTransformer((ctx, selection: Selection) =>
        selectContext(ctx, selection),
      ),
    };
  }

  scopeDecorators() {
    return {
      ...super.scopeDecorators(),
      ...this.selectorDecorators(),
    };
  }
}

export const defaultRegistrarS = new SatoriRegistrar(Context);
